/* $Id: test2.c,v 1.1 2005/01/25 14:25:52 jlaako Exp $ */

/*

    Shared memory object for POSIX/IEEE-1003.1 compliant systems.

    Copyright (C) 2005 Nokia Corporation.

    Contact: Jussi Laako <jussi.laako@nokia.com>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/


#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <sys/wait.h>
#include <pthread.h>

#include "sharedmem.h"
#include "shmalloc.h"


int main (int argc, char *argv[])
{
    long a1, a2, a3, a4;
    sharedmem_t shm;
    sharedmem_alloc_t shmalloc;

    /* create shared memory */
    if (sharedmem_create(&shm, "/test2.shm", 1048576) != 0)
    {
        printf("sharedmem_create(): %s\n", sharedmem_get_error_string(&shm));
        return 1;
    }

    /* initialize allocation */
    if (sharedmem_alloc_create(&shmalloc, &shm) != 0)
    {
        printf("sharedmem_alloc_create(): %s\n", 
            sharedmem_get_error_string(&shm));
        return 1;
    }

    /* allocate four blocks */
    a1 = sharedmem_alloc(&shmalloc, 256);
    if (a1 < 0)
    {
        printf("sharedmem_alloc(): %s\n", sharedmem_get_error_string(&shm));
        goto bail_out;
    }
    strcpy(sharedmem_alloc_get_ptr(&shmalloc, a1), "First");

    a2 = sharedmem_alloc(&shmalloc, 256);
    if (a2 < 0)
    {
        printf("sharedmem_alloc(): %s\n", sharedmem_get_error_string(&shm));
        goto bail_out;
    }
    strcpy(sharedmem_alloc_get_ptr(&shmalloc, a2), "Second");

    a3 = sharedmem_alloc(&shmalloc, 256);
    if (a3 < 0)
    {
        printf("sharedmem_alloc(): %s\n", sharedmem_get_error_string(&shm));
        goto bail_out;
    }
    strcpy(sharedmem_alloc_get_ptr(&shmalloc, a3), "Third");

    a4 = sharedmem_alloc(&shmalloc, 256);
    if (a4 < 0)
    {
        printf("sharedmem_alloc(): %s\n", sharedmem_get_error_string(&shm));
        goto bail_out;
    }
    strcpy(sharedmem_alloc_get_ptr(&shmalloc, a4), "Fourth");

    /* free two central blocks */
    if (sharedmem_free(&shmalloc, a3) != 0)
    {
        printf("sharedmem_free(): %s\n", sharedmem_get_error_string(&shm));
        goto bail_out;
    }
    if (sharedmem_free(&shmalloc, a2) != 0)
    {
        printf("sharedmem_free(): %s\n", sharedmem_get_error_string(&shm));
        goto bail_out;
    }

    /* allocate two new blocks of different size */
    a2 = sharedmem_alloc(&shmalloc, 384);
    if (a2 < 0)
    {
        printf("sharedmem_alloc(): %s\n", sharedmem_get_error_string(&shm));
        goto bail_out;
    }
    strcpy(sharedmem_alloc_get_ptr(&shmalloc, a2), "Second");

    a3 = sharedmem_alloc(&shmalloc, 32);
    if (a3 < 0)
    {
        printf("sharedmem_alloc(): %s\n", sharedmem_get_error_string(&shm));
        goto bail_out;
    }
    strcpy(sharedmem_alloc_get_ptr(&shmalloc, a3), "Third");

    /* print some info */
    printf("%ld\t%ld\t%ld\t%ld\n", a1, a2, a3, a4);
    printf("%s\t%s\t%s\t%s\n",
        (char *) sharedmem_alloc_get_ptr(&shmalloc, a1),
        (char *) sharedmem_alloc_get_ptr(&shmalloc, a2),
        (char *) sharedmem_alloc_get_ptr(&shmalloc, a3),
        (char *) sharedmem_alloc_get_ptr(&shmalloc, a4));

    /* free the allocations  (in random order) */
    if (sharedmem_free(&shmalloc, a2) != 0)
    {
        printf("sharedmem_free(): %s\n", sharedmem_get_error_string(&shm));
    }
    if (sharedmem_free(&shmalloc, a4) != 0)
    {
        printf("sharedmem_free(): %s\n", sharedmem_get_error_string(&shm));
    }
    if (sharedmem_free(&shmalloc, a1) != 0)
    {
        printf("sharedmem_free(): %s\n", sharedmem_get_error_string(&shm));
    }
    if (sharedmem_free(&shmalloc, a3) != 0)
    {
        printf("sharedmem_free(): %s\n", sharedmem_get_error_string(&shm));
    }

bail_out:
    if (sharedmem_close(&shm) != 0)
    {
        printf("sharedmem_close(): %s\n", sharedmem_get_error_string(&shm));
    }

    return 0;
}
