/* $Id: test.c,v 1.1 2004/12/22 14:10:29 jlaako Exp $ */

/*

    Shared memory object for POSIX/IEEE-1003.1 compliant systems.

    Copyright (C) 2005 Nokia Corporation.

    Contact: Jussi Laako <jussi.laako@nokia.com>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/


#include <stdio.h>
#include <unistd.h>
#include <sys/wait.h>
#include <pthread.h>

#include "sharedmem.h"


typedef struct _data_t
{
    int i;
    int r;
} data_t;


void parent ()
{
    int cntr = 0;
    sharedmem_t shm;
    data_t *shmdata;

puts("parent entry");    
    if (sharedmem_create(&shm, "/sharedmem.test", sizeof(data_t)))
    {
        fprintf(stderr, "%s\n", sharedmem_get_error_string(&shm));
        return;
    }
    shmdata = (data_t *) SHAREDMEM_PTR(&shm);
    shmdata->r = 1;
    while (cntr < 15)
    {
puts("parent lock");
        pthread_mutex_lock(SHAREDMEM_MUTEX(&shm));
        shmdata->i = cntr;
puts("parent signal");
        pthread_cond_signal(SHAREDMEM_COND(&shm));
puts("parent unlock");
        pthread_mutex_unlock(SHAREDMEM_MUTEX(&shm));
        cntr++;
        sleep(1);
    }
puts("parent final lock");
    pthread_mutex_lock(SHAREDMEM_MUTEX(&shm));
    shmdata->r = 0;
puts("parent final broadcast");
    pthread_cond_broadcast(SHAREDMEM_COND(&shm));
puts("parent final unlock");
    pthread_mutex_unlock(SHAREDMEM_MUTEX(&shm));
    if (sharedmem_close(&shm))
    {
        fprintf(stderr, "%s\n", sharedmem_get_error_string(&shm));
        return;
    }
}


void child ()
{
    int r = 1;
    int l;
    sharedmem_t shm;
    data_t *shmdata;
    
puts("child entry");
    if (sharedmem_open(&shm, "/sharedmem.test"))
    {
        fprintf(stderr, "%s\n", sharedmem_get_error_string(&shm));
        return;
    }
    shmdata = (data_t *) SHAREDMEM_PTR(&shm);
    while (r)
    {
puts("child lock");
        pthread_mutex_lock(SHAREDMEM_MUTEX(&shm));
puts("child wait");
        pthread_cond_wait(SHAREDMEM_COND(&shm), SHAREDMEM_MUTEX(&shm));
        l = shmdata->i;
        r = shmdata->r;
puts("child unlock");
        pthread_mutex_unlock(SHAREDMEM_MUTEX(&shm));
        fprintf(stdout, "child: %d\n", l);
    }
    if (sharedmem_close(&shm))
    {
        fprintf(stderr, "%s\n", sharedmem_get_error_string(&shm));
        return;
    }
}


int main (int argc, char *argv[])
{
    pid_t pid_child;
    
    pid_child = fork();
    if (pid_child != 0)
    {
        parent();
        waitpid(pid_child, NULL, 0);
    }
    else
    {
        sleep(1);
        child();
    }

    return 0;
}
