/* $Id: sharedmem_private.h,v 1.1 2005/02/03 11:02:19 jlaako Exp $ */

/*

    Shared memory object for POSIX/IEEE-1003.1 compliant systems.

    Copyright (C) 2005 Nokia Corporation.

    Contact: Jussi Laako <jussi.laako@nokia.com>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/


#ifndef SHAREDMEM_PRIVATE_H
#define SHAREDMEM_PRIVATE_H

#ifdef __cplusplus
extern "C" {
#endif


extern long sharedmem_page_size;  /**< System page size */

/**
    \internal

    Set error message based on errno.

    \param inst Instance to shared memory object
    \param error_code Standard errno returned at some stage
    \param error_str Error string to associate with the error
*/
void _sharedmem_set_error (sharedmem_t *inst, int error_code,
    const char *error_str);


#ifdef __cplusplus
}
#endif

#endif
