/**
    UPnP/AV GnomeVFS browser (Command Line)

    This file contains a wrapper, which uses DBUS to control media playing
    engine.

    Copyright 2006 Nokia Corporation. All rights reserved.
	
    Contact: Aapo Makela <aapo.makela@nokia.com>
    
    This library is free software; you can redistribute it and/or modify it
    under the terms of the GNU Lesser General Public License version 2.1 as 
    published by the Free Software Foundation.
  
    This library is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
    General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with this library; if not, write to the Free Software Foundation,
    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

#ifndef _PLAYER_H_
#define _PLAYER_H_

#include <glib.h>
#include <dbus/dbus.h>

/**
 * PLAYER_VOLUME_MODIFIER:
 *
 * Modification value for modding the value into format engine or volumebar
 * understands.
 **/
#define PLAYER_VOLUME_MODIFIER 100.0

/**
 * PLAYER_DBUS_ENGINE_INTERFACE_NAME:
 *
 * DBUS interface name for the media player engine. The music player
 * interface object name.
 **/
#define PLAYER_DBUS_ENGINE_INTERFACE_NAME "com.nokia.osso_media_server.music"

/**
 * PLAYER_DBUS_ENGINE_OBJECT_NAME:
 *
 * DBUS interface object path for media player engine.
 **/
#define PLAYER_DBUS_ENGINE_OBJECT_NAME "/com/nokia/osso_media_server"

/**
 * PLAYER_DBUS_ENGINE_SERVICE_NAME:
 *
 * DBUS interface name for media player engine.
 **/
#define PLAYER_DBUS_ENGINE_SERVICE_NAME "com.nokia.osso_media_server"

/**
 * PLAYER_DBUS_ENGINE_INTERFACE_ERROR_NAME:
 *
 * DBUS interface name for media player engine.
 **/
#define PLAYER_DBUS_ENGINE_INTERFACE_ERROR_NAME "com.nokia.osso_media_server"\
                                                ".music.error"

/**
 * PLAYER_DBUS_MUSIC_PLAYER_ERROR:
 *
 * Error type sent to a calling client when something could not be
 * done in DBUS functions.
 **/
#define PLAYER_DBUS_MUSIC_PLAYER_ERROR "com.nokia.osso_music_player.error"

#define PLAYER_PLAY_TIMEOUT 10

gboolean player_play_uri(DBusConnection *conn, const gchar *uri, GError **err);

gboolean player_stop(DBusConnection *conn, GError **err);

gboolean player_pause(DBusConnection *conn, GError **err);

gboolean player_set_mute(DBusConnection *conn, gboolean muted, GError **err);

gboolean player_set_volume(DBusConnection *conn, gint value, GError **err);

gboolean player_get_position(DBusConnection *conn, gint *pos, gint *length, GError **err);

#endif /* _PLAYER_H_ */
