/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the mozilla.org code.
 *
 * The Initial Developer of the Original Code is
 * Oleg Romashin <romaxa@gmail.com>
 *
 * Portions created by the Initial Developer are Copyright (C) 2005
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#ifndef gtkmozembed_prompter_h
#define gtkmozembed_prompter_h

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include <stddef.h>
#include <gtk/gtk.h>

#ifdef MOZILLA_CLIENT
#include "nscore.h"
#else /* MOZILLA_CLIENT */
#ifndef nscore_h__
/* Because this header may be included from files which not part of the mozilla
   build system, define macros from nscore.h */

#if (__GNUC__ >= 4) || (__GNUC__ == 3 && __GNUC_MINOR__ >= 3)
#define NS_HIDDEN __attribute__((visibility("hidden")))
#else
#define NS_HIDDEN
#endif

#define NS_FROZENCALL
#define NS_EXPORT_(type) type
#define NS_IMPORT_(type) type
#endif /* nscore_h__ */
#endif /* MOZILLA_CLIENT */

#ifdef XPCOM_GLUE

#define GTKMOZEMBED_API(type, name, params) \
  typedef type (NS_FROZENCALL * name##Type) params; \
  extern name##Type name NS_HIDDEN;

#else /* XPCOM_GLUE */

#ifdef _IMPL_GTKMOZEMBED
#define GTKMOZEMBED_API(type, name, params) NS_EXPORT_(type) name params;
#else
#define GTKMOZEMBED_API(type,name, params) NS_IMPORT_(type) name params;
#endif

#endif /* XPCOM_GLUE */

#define GTK_TYPE_MOZ_PROMPTER             (gtk_moz_prompter_get_type())
#define GTK_MOZ_PROMPTER(obj)             GTK_CHECK_CAST((obj), GTK_TYPE_MOZ_PROMPTER, GtkMozPrompter)
#define GTK_MOZ_PROMPTER_CLASS(klass)     GTK_CHECK_CLASS_CAST((klass), GTK_TYPE_MOZ_PROMPTER, GtkMozPrompterClass)
#define GTK_IS_MOZ_PROMPTER(obj)          GTK_CHECK_TYPE((obj), GTK_TYPE_MOZ_PROMPTER)
#define GTK_IS_MOZ_PROMPTER_CLASS(klass)  GTK_CHECK_CLASS_TYPE((klass), GTK_TYPE_MOZ_PROMPTER)
#define GTK_MOZ_PROMPTER_GET_CLASS(obj)   (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_MOZ_PROMPTER, GtkMozPrompterClass))

typedef struct _GtkMozPrompter        GtkMozPrompter;
typedef struct _GtkMozPrompterClass   GtkMozPrompterClass;
typedef struct _GtkMozPrompterPrivate GtkMozPrompterPrivate;

struct _GtkMozPrompter
{
  GObject  object;
};

struct _GtkMozPrompterClass
{
  GObjectClass parent_class;

  void     (* alert)           (GtkMozPrompter *embed, gpointer win, const char *title, const char *text, gboolean is_blocking,
                                const char *check_msg, gboolean *check_val);
  gboolean (* confirm)         (GtkMozPrompter *embed, gpointer win, const char *title, const char *text,
                                const char *check_msg, gboolean *check_val);
  gint     (* confirm_ex)      (GtkMozPrompter *embed, gpointer win, const char *title, const char *text, guint bt_flags,
                                const char *button1, const char *button2, const char *button3,
                                const char *check_msg, gboolean *check_val);
/* In prompt[_auth] callbacks please free old values by using g_free(*value|*user|*pass)
   before allocating new values, it will be freed inside gtkmozembed automatically */
  gboolean (* prompt)          (GtkMozPrompter *embed, gpointer win, const char *title, const char *text,
                                char **value, const char *check_msg, gboolean *check_val);
  gboolean (* prompt_auth)     (GtkMozPrompter *embed, gpointer win, const char *title, const char *text,
                                char **user, char **pass, const char *check_msg, gboolean *check_val);
  gboolean (* select)          (GtkMozPrompter *embed, gpointer win, const char *title, const char *text,
                                GList *list, gint *selected_item);
  void     (* cookie_dialog)   (GtkMozPrompter *embed,
                                gpointer win, gboolean *remember, gint* action, gulong expires,
                                const char *host, const char *name,
                                const char *value, const char *domain, const char *path);
};

GTKMOZEMBED_API(GType,              gtk_moz_prompter_get_type,           (void))
GTKMOZEMBED_API(GtkMozPrompter*,    gtk_moz_prompter_get,                (void))

typedef enum
{
  GTK_MOZ_EMBED_DIALOG_BUTTON_OK,
  GTK_MOZ_EMBED_DIALOG_BUTTON_CANCEL,
  GTK_MOZ_EMBED_DIALOG_BUTTON_YES,
  GTK_MOZ_EMBED_DIALOG_BUTTON_NO,
  GTK_MOZ_EMBED_DIALOG_BUTTON_SAVE,
  GTK_MOZ_EMBED_DIALOG_BUTTON_DONT_SAVE,
  GTK_MOZ_EMBED_DIALOG_BUTTON_REVERT,
  GTK_MOZ_EMBED_DIALOG_BUTTON_STRING
} GtkMozEmbedDialogButtons;

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* gtkmozembed_prompter_h */
