/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 tw=80 et cindent: */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the mozilla.org code.
 *
 * The Initial Developer of the Original Code is
 * Oleg Romashin <romaxa@gmail.com>
 *
 * Portions created by the Initial Developer are Copyright (C) 2005
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#ifndef gtkmozembed_hildon_h
#define gtkmozembed_hildon_h

#include <gtk/gtk.h>
#include "nsStringGlue.h"
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <libintl.h>

#ifdef USE_HILDON
#include <browser-translations.h>
#else 
#define _(String) (String)
#define TR_EMBED_ADDRESS "Address:"
#define TR_EMBED_SIZE "Size:"
#define TR_EMBED_NAME "Name:"
#define TR_WEB_UNKNOWN "Unknown"
#define TR_EMBED_INSTALL_COMPONENT_TITLE "Install component"
#define TR_EMBED_CHECKING_UPDATES "Checking for updates"
#define TR_EMBED_AVAIL_UPDATES_TITLE "Available updates"
#define TR_EMBED_BUTTON_INSTALL "Install"
#define TR_EMBED_PROGRESS_INSTALL "Installing"
#define TR_EMBED_INS_BUTTON_INSTALL "Select component first"
#define TR_EMBED_BUTTON_CANCEL "Cancel"
#define TR_EMBED_NOTE_RESTART "Browser restart required to\napply changes."
#define TR_EMBED_NOTE_NO_UPDATES "No updates found"
#define TR_EMBED_NOTE_SUCCESS_INSTALL "Success Installation."
#define TR_EMBED_NOTE_ERROR_INSTALL "Installation Error."
#define TR_EMBED_NOTE_INSTALL_NOTICE "If the software is not obtained from trusted source, and we unable to guarantee that the software will not harm your device and installation will be at your own risk.\nContinue anyway?"
#define TR_EMBED_NOTE_INSTALL_NOTICE2 "If the software is not obtained from trusted source, and we unable to guarantee that the software will not harm your device and installation will be at your own risk.\nContinue anyway?"
#define TR_EMBED_TITLE_INSTALL_NOTICE "Notice"
#endif

#define MAX_WIDTH_CHARS 60

gboolean gtkmozembed_hildon_install_dialog(GtkWindow *parent, const PRUnichar **aPackageList, PRUint32 aCount, PRBool sure);
GtkWidget* gtkmozembed_hildon_check_updates_dialog(GtkWindow *parent, GtkWidget **progress);
gboolean gtkmozembed_hildon_select_updates_dialog(GtkWindow *parent, GList **updates_list);
gboolean gtkmozembed_hildon_information_dialog(GtkWindow *parent, const gchar *text);
gboolean gtkmozembed_hildon_confirmation_dialog(GtkWindow *parent, const gchar *text);
GtkWidget *gtkmozembed_hildon_install_progress_banner (GtkWindow * parent, GtkWidget **progress);

#endif /* gtkmozembed_hildon_h */
