/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 tw=80 et cindent: */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the mozilla.org code.
 *
 * The Initial Developer of the Original Code is
 * Oleg Romashin <romaxa@gmail.com>
 *
 * Portions created by the Initial Developer are Copyright (C) 2005
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#ifdef __i386__
#undef USE_HILDON
#endif

#include "gtkmozembed_hildon.h"
#ifdef USE_HILDON
#include "hildon/hildon-note.h"
#include "hildon/hildon-banner.h"
#include <hildon/hildon-helper.h>
#endif
#include "nsIExtensionManager.h"

static gboolean
gtkmozembed_hildon_alien_notice(GtkWindow *parent, PRBool sure)
{
    int flags = GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT;
    GtkWidget *dialog = gtk_dialog_new_with_buttons (_(TR_EMBED_TITLE_INSTALL_NOTICE),
                                                   parent,
                                                   (GtkDialogFlags)flags,
                                                   GTK_STOCK_OK,
                                                   GTK_RESPONSE_ACCEPT,
                                                   GTK_STOCK_CANCEL,
                                                   GTK_RESPONSE_REJECT,
                                                   NULL);

    gtk_dialog_set_has_separator (GTK_DIALOG (dialog), FALSE);
    const char *text = (1
                        ? _(TR_EMBED_NOTE_INSTALL_NOTICE)
                        : _(TR_EMBED_NOTE_INSTALL_NOTICE2));

    GtkWidget *label = gtk_label_new (text);
    gtk_label_set_line_wrap (GTK_LABEL (label), TRUE);
    gtk_container_add (GTK_CONTAINER (GTK_DIALOG (dialog)->vbox), label);
    
    gtk_widget_show_all(GTK_WIDGET(GTK_DIALOG (dialog)->vbox));

    gint result = gtk_dialog_run (GTK_DIALOG (dialog));
    gtk_widget_destroy (dialog);
    return result == GTK_RESPONSE_ACCEPT?TRUE:FALSE;

}

gboolean
gtkmozembed_hildon_install_dialog(GtkWindow *parent, const PRUnichar **aPackageList, PRUint32 aCount, PRBool sure)
{
  if (aCount < 1) return FALSE;
  if (!aPackageList[0][0] || !aPackageList[1][0]) return FALSE;

  GtkWidget *label;
  int flags = GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT;
  GtkWidget *dialog = gtk_dialog_new_with_buttons (_(TR_EMBED_INSTALL_COMPONENT_TITLE),
                                                   parent,
                                                   (GtkDialogFlags)flags,
                                                   GTK_STOCK_OK,
                                                   GTK_RESPONSE_ACCEPT,
                                                   GTK_STOCK_CANCEL,
                                                   GTK_RESPONSE_REJECT,
                                                   NULL);
  gtk_window_set_modal(GTK_WINDOW(dialog), TRUE);
  gtk_window_set_destroy_with_parent(GTK_WINDOW(dialog), TRUE);
  gtk_window_set_transient_for(GTK_WINDOW(dialog), GTK_WINDOW(parent));

  gtk_container_set_border_width (GTK_CONTAINER (dialog), 5);
  GtkTable *table = GTK_TABLE (gtk_table_new (3, 2, FALSE));

  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (dialog)->vbox), GTK_WIDGET (table));

  gtk_container_set_border_width (GTK_CONTAINER(GTK_DIALOG (dialog)->vbox), 0);

  label = gtk_label_new (_(TR_EMBED_NAME));
  gtk_label_set_use_markup (GTK_LABEL (label), TRUE);
  gtk_misc_set_alignment (GTK_MISC (label), 1, 0);
  gtk_misc_set_padding (GTK_MISC (label), 5, 0);

  gtk_table_attach (table, label, 0, 1, 0, 1,
                    (GtkAttachOptions) GTK_FILL, (GtkAttachOptions)0, 0, 0);

  label = gtk_label_new (_(TR_EMBED_SIZE));
  gtk_label_set_use_markup (GTK_LABEL (label), TRUE);
  gtk_misc_set_alignment (GTK_MISC (label), 1, 0);
  gtk_misc_set_padding (GTK_MISC (label), 5, 0);

  gtk_table_attach (table, label, 0, 1, 1, 2,
                    (GtkAttachOptions) GTK_FILL, (GtkAttachOptions)0, 0, 0);

  label = gtk_label_new (_(TR_EMBED_ADDRESS));
  gtk_label_set_use_markup (GTK_LABEL (label), TRUE);
  gtk_misc_set_alignment (GTK_MISC (label), 1, 0);
  gtk_misc_set_padding (GTK_MISC (label), 5, 0);

  gtk_table_attach (table, label, 0, 1, 2, 3,
                    (GtkAttachOptions) GTK_FILL, (GtkAttachOptions)0, 0, 0);

  label = gtk_label_new (NS_ConvertUTF16toUTF8(&aPackageList[0][0]).get());
  gtk_label_set_use_markup (GTK_LABEL (label), TRUE);
  gtk_label_set_max_width_chars (GTK_LABEL (label), MAX_WIDTH_CHARS);
  gtk_label_set_ellipsize (GTK_LABEL (label), PANGO_ELLIPSIZE_END);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0);
  gtk_misc_set_padding (GTK_MISC (label), 0, 0);

  gtk_table_attach (table, label, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_SHRINK | GTK_FILL), GTK_SHRINK, 0, 0);

  label = gtk_label_new (_(TR_WEB_UNKNOWN));
  gtk_label_set_use_markup (GTK_LABEL (label), TRUE);
  gtk_label_set_max_width_chars (GTK_LABEL (label), MAX_WIDTH_CHARS);
  gtk_label_set_ellipsize (GTK_LABEL (label), PANGO_ELLIPSIZE_END);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0);
  gtk_misc_set_padding (GTK_MISC (label), 0, 0);

  gtk_table_attach (table, label, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_SHRINK | GTK_FILL), GTK_SHRINK, 0, 0);

  label = gtk_label_new (NS_ConvertUTF16toUTF8(&aPackageList[1][0]).get());
  gtk_label_set_use_markup (GTK_LABEL (label), TRUE);
  gtk_label_set_max_width_chars (GTK_LABEL (label), MAX_WIDTH_CHARS);
  gtk_label_set_ellipsize (GTK_LABEL (label), PANGO_ELLIPSIZE_END);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0);
  gtk_misc_set_padding (GTK_MISC (label), 0, 0);

  gtk_table_attach (table, label, 1, 2, 2, 3,
                    (GtkAttachOptions) (GTK_SHRINK | GTK_FILL), GTK_SHRINK, 0, 0);


  gtk_widget_show_all (GTK_DIALOG (dialog)->vbox);
  gtk_dialog_set_has_separator (GTK_DIALOG (dialog), FALSE);

  gboolean confirm = FALSE;
  gint result = gtk_dialog_run (GTK_DIALOG (dialog));
  gtk_widget_destroy (dialog);
  return result == GTK_RESPONSE_ACCEPT?gtkmozembed_hildon_alien_notice(parent, sure):FALSE;
}

GtkWidget*
gtkmozembed_hildon_install_progress_banner(GtkWindow *parent, GtkWidget **progress)
{
  GtkWidget *progress_load = gtk_progress_bar_new ();
  gtk_widget_set_size_request (GTK_WIDGET (progress_load), 240, -1);

#ifdef USE_HILDON
  HildonBanner * hildon_banner = NULL;
  GtkWidget *dialog = hildon_banner_show_progress (NULL, GTK_PROGRESS_BAR(progress_load), _(TR_EMBED_PROGRESS_INSTALL));
#else

  GtkWidget *label;
  int flags = GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT;
  GtkWidget *dialog = gtk_dialog_new_with_buttons (_(TR_EMBED_PROGRESS_INSTALL),
                                                   parent,
                                                   (GtkDialogFlags)flags,
                                                   NULL);
  gtk_window_set_modal(GTK_WINDOW(dialog), TRUE);
  gtk_window_set_destroy_with_parent(GTK_WINDOW(dialog), TRUE);
  gtk_window_set_transient_for(GTK_WINDOW(dialog), GTK_WINDOW(parent));

  gtk_container_set_border_width (GTK_CONTAINER (dialog), 5);
  //gtk_window_set_has_frame(GTK_WINDOW(dialog), );
  //gtk_window_set_decorated(GTK_WINDOW(dialog), FALSE);

  label = gtk_label_new (_(TR_EMBED_CHECKING_UPDATES));
  gtk_label_set_use_markup (GTK_LABEL (label), TRUE);
  //gtk_misc_set_alignment (GTK_MISC (label), 0, 0);
  gtk_misc_set_padding (GTK_MISC (label), 5, 5);

  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (dialog)->vbox), GTK_WIDGET (label));
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (dialog)->vbox), GTK_WIDGET (progress_load));

  gtk_container_set_border_width (GTK_CONTAINER(GTK_DIALOG (dialog)->vbox), 0);
  gtk_dialog_set_has_separator (GTK_DIALOG (dialog), FALSE);
  gtk_widget_show_all(GTK_WIDGET(GTK_DIALOG(dialog)->vbox));
#endif

  //gtk_progress_bar_set_pulse_step(GTK_PROGRESS_BAR(progress_load), 0.1);
  if (progress)
    *progress = progress_load;
  return dialog;
}


GtkWidget*
gtkmozembed_hildon_check_updates_dialog(GtkWindow *parent, GtkWidget **progress)
{
  GtkWidget *progress_load = gtk_progress_bar_new ();
  gtk_widget_set_size_request (GTK_WIDGET (progress_load), 240, -1);

#ifdef USE_HILDON
  GtkWidget *dialog = hildon_note_new_cancel_with_progress_bar(parent,
                                                              _(TR_EMBED_CHECKING_UPDATES),
                                                              GTK_PROGRESS_BAR(progress_load));
#else

  GtkWidget *label;
  int flags = GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT;
  GtkWidget *dialog = gtk_dialog_new_with_buttons (_(TR_EMBED_CHECKING_UPDATES),
                                                   parent,
                                                   (GtkDialogFlags)flags,
                                                   GTK_STOCK_OK,
                                                   GTK_RESPONSE_ACCEPT,
                                                   NULL);
  gtk_window_set_modal(GTK_WINDOW(dialog), TRUE);
  gtk_window_set_destroy_with_parent(GTK_WINDOW(dialog), TRUE);
  gtk_window_set_transient_for(GTK_WINDOW(dialog), GTK_WINDOW(parent));

  gtk_container_set_border_width (GTK_CONTAINER (dialog), 5);
  //gtk_window_set_has_frame(GTK_WINDOW(dialog), );
  //gtk_window_set_decorated(GTK_WINDOW(dialog), FALSE);

  label = gtk_label_new (_(TR_EMBED_CHECKING_UPDATES));
  gtk_label_set_use_markup (GTK_LABEL (label), TRUE);
  //gtk_misc_set_alignment (GTK_MISC (label), 0, 0);
  gtk_misc_set_padding (GTK_MISC (label), 5, 5);

  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (dialog)->vbox), GTK_WIDGET (label));
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (dialog)->vbox), GTK_WIDGET (progress_load));

  gtk_container_set_border_width (GTK_CONTAINER(GTK_DIALOG (dialog)->vbox), 0);
  gtk_dialog_set_has_separator (GTK_DIALOG (dialog), FALSE);
  gtk_widget_show_all(GTK_WIDGET(GTK_DIALOG(dialog)->vbox));
#endif

  //gtk_progress_bar_set_pulse_step(GTK_PROGRESS_BAR(progress_load), 0.1);
  if (progress)
    *progress = progress_load;
  return dialog;
}

static void
select_update_toggled_cb(GtkCellRendererToggle *cell_renderer,
                         gchar *path, GObject *tree)
{
    GtkTreeIter iter;
    gboolean active;

    /* Get the GtkTreeModel iter */
    GtkTreeModel *model =
        gtk_tree_view_get_model (GTK_TREE_VIEW(tree));

    if ( !gtk_tree_model_get_iter_from_string(model, &iter, path) ) {
        return;
    }
    /* Get boolean value */
    gtk_tree_model_get(model, &iter, 1, &active, -1);

    /* Change the iter value on the TreeModel */
    gtk_list_store_set(GTK_LIST_STORE(model), &iter,
                       1, !active, -1);

    GtkWidget* bt = (GtkWidget*)g_object_get_data(tree, "install_bt");
    if (!gtk_tree_model_get_iter_first(model, &iter)) {
        gtk_widget_set_sensitive (GTK_WIDGET (bt), FALSE);
        return;
    }
    gtk_tree_model_get(model, &iter, 1, &active, -1);
    if (active) {
        gtk_widget_set_sensitive (GTK_WIDGET (bt), active);
        return;
    }
    while (gtk_tree_model_iter_next(model, &iter))
    {
        active = TRUE;
        gtk_tree_model_get(model, &iter, 1, &active, -1);
        if (active) {
            gtk_widget_set_sensitive (GTK_WIDGET (bt), active);
            return;
        }
    }
    gtk_widget_set_sensitive (GTK_WIDGET (bt), FALSE);
}

gboolean
gtkmozembed_hildon_select_updates_dialog(GtkWindow *parent, GList **updates_list)
{
  g_return_val_if_fail(updates_list, FALSE);
  GtkDialog *dialog = NULL;
  GtkWidget *swindow = NULL;
  GtkWidget *label = NULL;

  GtkListStore *store = NULL;
  GtkTreeViewColumn *column = NULL;
  GtkCellRenderer *renderer = NULL;

  dialog = GTK_DIALOG(gtk_dialog_new());

  gtk_widget_set_size_request(GTK_WIDGET(dialog), 630, 310);

    /*Select, Delete and cancel buttons */
  GtkWidget *InstallButton =
        gtk_dialog_add_button(dialog, _(TR_EMBED_BUTTON_INSTALL), GTK_RESPONSE_OK);
  GtkWidget *CloseButton =
        gtk_dialog_add_button(dialog, _(TR_EMBED_BUTTON_CANCEL), GTK_RESPONSE_CANCEL);

  store = gtk_list_store_new(2, G_TYPE_STRING, G_TYPE_BOOLEAN);
  GtkWidget *tree = gtk_tree_view_new_with_model(GTK_TREE_MODEL(store));
  g_object_set_data(G_OBJECT(tree), "install_bt", G_OBJECT(InstallButton));

#ifdef USE_HILDON
  hildon_helper_set_insensitive_message (GTK_WIDGET(InstallButton), _(TR_EMBED_INS_BUTTON_INSTALL));
#endif

  gtk_tree_view_set_headers_visible(GTK_TREE_VIEW(tree), FALSE);
  gtk_tree_view_set_rules_hint(GTK_TREE_VIEW(tree), TRUE);

  renderer = gtk_cell_renderer_text_new();
  column = gtk_tree_view_column_new_with_attributes("",
                                                    renderer, "text", 0,
                                                    NULL);
  gtk_tree_view_column_set_sizing(column, GTK_TREE_VIEW_COLUMN_FIXED);
  gtk_tree_view_column_set_fixed_width(column, 525);
  gtk_tree_view_append_column(GTK_TREE_VIEW(tree), column);

  renderer = gtk_cell_renderer_toggle_new();
  g_object_set (renderer, "activatable", TRUE, NULL);

  g_signal_connect(G_OBJECT(renderer), "toggled", 
                   G_CALLBACK(select_update_toggled_cb), 
                   tree); 

  column = gtk_tree_view_column_new_with_attributes("", renderer, "active", 1, NULL);

  gtk_tree_view_column_set_sizing(column, GTK_TREE_VIEW_COLUMN_FIXED);
  gtk_tree_view_append_column(GTK_TREE_VIEW(tree), column);

  swindow = gtk_scrolled_window_new(NULL, NULL);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(swindow),
                                 GTK_POLICY_NEVER,
                                 GTK_POLICY_AUTOMATIC);

  gtk_container_add(GTK_CONTAINER(GTK_BOX(GTK_DIALOG(dialog)->vbox)), swindow);

  gtk_container_add(GTK_CONTAINER(swindow), tree);
  gint i;
  GtkTreeIter iter;
  gtk_list_store_clear(GTK_LIST_STORE(store));
  for (i = 0; i < g_list_length(*updates_list); i++)
  {
        gtk_list_store_append(store, &iter);
        nsIUpdateItem *extension = static_cast<nsIUpdateItem *>(g_list_nth_data(*updates_list, i));
        nsString str, ver;
        extension->GetName(str);
        extension->GetVersion(ver);
        str.Append(NS_LITERAL_STRING(" "));
        str.Append(ver);
        gtk_list_store_set(store, &iter,
                           0, NS_ConvertUTF16toUTF8(str).get(),
                           1, TRUE, -1);
  }

  gtk_dialog_set_has_separator(dialog, FALSE);
  gtk_widget_show_all(GTK_WIDGET(GTK_DIALOG(dialog)->vbox));
  gtk_window_set_modal(GTK_WINDOW(dialog), TRUE);
  gtk_window_set_destroy_with_parent(GTK_WINDOW(dialog), TRUE);
  gtk_window_set_transient_for(GTK_WINDOW(dialog), GTK_WINDOW(parent));
  gtk_window_set_title(GTK_WINDOW(dialog), _(TR_EMBED_AVAIL_UPDATES_TITLE));
  gint result = gtk_dialog_run (GTK_DIALOG (dialog));

  GtkTreeModel *model =
      gtk_tree_view_get_model (GTK_TREE_VIEW(tree));
  gboolean active = TRUE;

  GList *new_list = NULL;
  GList *c = *updates_list;
  if (gtk_tree_model_get_iter_first(model, &iter)) {
    gtk_tree_model_get(model, &iter, 1, &active, -1);
    if (active) new_list = g_list_append(new_list, c->data);
    while (gtk_tree_model_iter_next(model, &iter))
    {
      active = TRUE;
      gtk_tree_model_get(model, &iter, 1, &active, -1);
      if (c) c = c->next;
      if (active) new_list = g_list_append(new_list, c->data);
    }
  }
  gtk_widget_destroy (GTK_WIDGET(dialog));
  *updates_list = new_list;
  if (!new_list) result = GTK_RESPONSE_CANCEL;
  return result == GTK_RESPONSE_OK?TRUE:FALSE;
}

gboolean
gtkmozembed_hildon_information_dialog(GtkWindow *parent, const gchar *text)
{
#ifdef USE_HILDON
  GtkWidget* dialog = hildon_note_new_information(parent, text);
#else
  GtkWidget *label;
  int flags = GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT;
  GtkWidget *dialog = gtk_dialog_new_with_buttons ("Information",
                                                   parent,
                                                   (GtkDialogFlags)flags,
                                                   GTK_STOCK_OK,
                                                   GTK_RESPONSE_OK,
                                                   NULL);

  gtk_container_set_border_width (GTK_CONTAINER (dialog), 5);

  label = gtk_label_new (text);
  gtk_label_set_use_markup (GTK_LABEL (label), TRUE);
  gtk_misc_set_padding (GTK_MISC (label), 5, 5);

  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (dialog)->vbox), GTK_WIDGET (label));

  gtk_container_set_border_width (GTK_CONTAINER(GTK_DIALOG (dialog)->vbox), 0);
  gtk_dialog_set_has_separator (GTK_DIALOG (dialog), FALSE);
  gtk_widget_show_all(GTK_WIDGET(GTK_DIALOG(dialog)->vbox));

#endif

  gtk_window_set_modal(GTK_WINDOW(dialog), TRUE);
  gtk_window_set_destroy_with_parent(GTK_WINDOW(dialog), TRUE);
  gtk_window_set_transient_for(GTK_WINDOW(dialog), GTK_WINDOW(parent));
  gint result = gtk_dialog_run (GTK_DIALOG (dialog));
  gtk_widget_destroy (GTK_WIDGET(dialog));
  return result == GTK_RESPONSE_OK?TRUE:FALSE;
  
}

gboolean
gtkmozembed_hildon_confirmation_dialog(GtkWindow *parent, const gchar *text)
{
#ifdef USE_HILDON
  GtkWidget* dialog = hildon_note_new_confirmation(parent, text);
#else
  GtkWidget *label;
  int flags = GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT;
  GtkWidget *dialog = gtk_dialog_new_with_buttons ("Confirmation",
                                                   parent,
                                                   (GtkDialogFlags)flags,
                                                   GTK_STOCK_OK,
                                                   GTK_RESPONSE_OK,
                                                   GTK_STOCK_CANCEL,
                                                   GTK_RESPONSE_CANCEL,
                                                   NULL);

  gtk_container_set_border_width (GTK_CONTAINER (dialog), 5);

  label = gtk_label_new (text);
  gtk_label_set_use_markup (GTK_LABEL (label), TRUE);
  gtk_misc_set_padding (GTK_MISC (label), 5, 5);

  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (dialog)->vbox), GTK_WIDGET (label));

  gtk_container_set_border_width (GTK_CONTAINER(GTK_DIALOG (dialog)->vbox), 0);
  gtk_dialog_set_has_separator (GTK_DIALOG (dialog), FALSE);
  gtk_widget_show_all(GTK_WIDGET(GTK_DIALOG(dialog)->vbox));

#endif

  gtk_window_set_modal(GTK_WINDOW(dialog), TRUE);
  gtk_window_set_destroy_with_parent(GTK_WINDOW(dialog), TRUE);
  gtk_window_set_transient_for(GTK_WINDOW(dialog), GTK_WINDOW(parent));
  gint result = gtk_dialog_run (GTK_DIALOG (dialog));
  gtk_widget_destroy (GTK_WIDGET(dialog));
  return result == GTK_RESPONSE_OK?TRUE:FALSE;
  
}

