/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/* vim:expandtab:shiftwidth=4:tabstop=4: */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is mozilla.org code.
 *
 * The Initial Developer of the Original Code is
 * Netscape Communications Corporation.
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *  Brian Ryner <bryner@brianryner.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include "GtkPrompterService.h"
#include "nsStringGlue.h"
#include "EmbedGtkTools.h"

#include "gtkmozembed_prompter.h"

#include "EmbedEventListener.h" // FIXME : REMOVEME see old/135_disable_longpress_on_js_alert.diff

extern guint moz_prompter_signals[EMBED_PROMPT_LAST_SIGNAL];

GtkPrompterService::GtkPrompterService()
{
}

GtkPrompterService::~GtkPrompterService()
{
}

NS_IMPL_ISUPPORTS3(GtkPrompterService, nsIPromptService, nsINonBlockingAlertService, nsICookiePromptService)

NS_IMETHODIMP
GtkPrompterService::Alert(nsIDOMWindow* aParent, const PRUnichar* aDialogTitle, 
                          const PRUnichar* aDialogText)
{
    g_signal_emit(G_OBJECT(gtk_moz_prompter_get()),
                  moz_prompter_signals[ALERT], 0,
                  GetGtkWidgetForDOMWindow(aParent),
                  NS_ConvertUTF16toUTF8(aDialogTitle).get(),
                  NS_ConvertUTF16toUTF8(aDialogText).get(),
                  TRUE,
                  nsnull,
                  nsnull);

    return NS_OK;
}

NS_IMETHODIMP
GtkPrompterService::ShowNonBlockingAlert(nsIDOMWindow* aParent, const PRUnichar* aDialogTitle,
                                         const PRUnichar* aDialogText)
{
    g_signal_emit(G_OBJECT(gtk_moz_prompter_get()),
                  moz_prompter_signals[ALERT], 0,
                  GetGtkWidgetForDOMWindow(aParent),
                  NS_ConvertUTF16toUTF8(aDialogTitle).get(),
                  NS_ConvertUTF16toUTF8(aDialogText).get(),
                  FALSE,
                  nsnull,
                  nsnull);

    return NS_OK;
}

NS_IMETHODIMP
GtkPrompterService::AlertCheck(nsIDOMWindow* aParent,
                               const PRUnichar* aDialogTitle,
                               const PRUnichar* aDialogText,
                               const PRUnichar* aCheckMsg, PRBool* aCheckValue)
{
    NS_ENSURE_ARG_POINTER(aCheckValue);

    g_signal_emit(G_OBJECT(gtk_moz_prompter_get()),
                  moz_prompter_signals[ALERT], 0,
                  GetGtkWidgetForDOMWindow(aParent),
                  NS_ConvertUTF16toUTF8(aDialogTitle).get(),
                  NS_ConvertUTF16toUTF8(aDialogText).get(),
                  FALSE,
                  NS_ConvertUTF16toUTF8(aCheckMsg).get(),
                  aCheckValue);

    return NS_OK;
}

NS_IMETHODIMP
GtkPrompterService::Confirm(nsIDOMWindow* aParent,
                            const PRUnichar* aDialogTitle,
                            const PRUnichar* aDialogText, PRBool* aConfirm)
{
    g_signal_emit(G_OBJECT(gtk_moz_prompter_get()),
                  moz_prompter_signals[CONFIRM], 0,
                  GetGtkWidgetForDOMWindow(aParent),
                  NS_ConvertUTF16toUTF8(aDialogTitle).get(),
                  NS_ConvertUTF16toUTF8(aDialogText).get(),
                  nsnull,
                  nsnull,
                  aConfirm);

    return NS_OK;
}

NS_IMETHODIMP
GtkPrompterService::ConfirmCheck(nsIDOMWindow* aParent,
                                 const PRUnichar* aDialogTitle,
                                 const PRUnichar* aDialogText,
                                 const PRUnichar* aCheckMsg,
                                 PRBool* aCheckValue, PRBool* aConfirm)
{
    NS_ENSURE_ARG_POINTER(aCheckValue);

    g_signal_emit(G_OBJECT(gtk_moz_prompter_get()),
                  moz_prompter_signals[CONFIRM], 0,
                  GetGtkWidgetForDOMWindow(aParent),
                  NS_ConvertUTF16toUTF8(aDialogTitle).get(),
                  NS_ConvertUTF16toUTF8(aDialogTitle).get(),
                  NS_ConvertUTF16toUTF8(aCheckMsg).get(),
                  aCheckValue,
                  aConfirm);

    return NS_OK;
}

NS_IMETHODIMP
GtkPrompterService::ConfirmEx(nsIDOMWindow* aParent,
                              const PRUnichar* aDialogTitle,
                              const PRUnichar* aDialogText,
                              PRUint32 aButtonFlags,
                              const PRUnichar* aButton0Title,
                              const PRUnichar* aButton1Title,
                              const PRUnichar* aButton2Title,
                              const PRUnichar* aCheckMsg, PRBool* aCheckValue,
                              PRInt32* aRetVal)
{
    g_signal_emit(G_OBJECT(gtk_moz_prompter_get()),
                  moz_prompter_signals[CONFIRM_EX], 0,
                  GetGtkWidgetForDOMWindow(aParent),
                  NS_ConvertUTF16toUTF8(aDialogTitle).get(),
                  NS_ConvertUTF16toUTF8(aDialogText).get(),
                  aButtonFlags, /* GtkMozEmbedDialogButtonsFlags */
                  NS_ConvertUTF16toUTF8(aButton0Title).get(),
                  NS_ConvertUTF16toUTF8(aButton1Title).get(),
                  NS_ConvertUTF16toUTF8(aButton2Title).get(),
                  NS_ConvertUTF16toUTF8(aCheckMsg).get(),
                  aCheckValue, aRetVal);

    return NS_OK;
}

NS_IMETHODIMP
GtkPrompterService::Prompt(nsIDOMWindow* aParent, const PRUnichar* aDialogTitle,
                           const PRUnichar* aDialogText, PRUnichar** aValue,
                           const PRUnichar* aCheckMsg, PRBool* aCheckValue,
                           PRBool* aConfirm)
{
    gchar * aGValue = ToNewCString(NS_ConvertUTF16toUTF8(*aValue));

    g_signal_emit(G_OBJECT(gtk_moz_prompter_get()),
                  moz_prompter_signals[PROMPT], 0,
                  GetGtkWidgetForDOMWindow(aParent),
                  NS_ConvertUTF16toUTF8(aDialogTitle).get(),
                  NS_ConvertUTF16toUTF8(aDialogText).get(),
                  &aGValue,
                  NS_ConvertUTF16toUTF8(aCheckMsg).get(),
                  aCheckValue, aConfirm);

    if (*aConfirm) {
        if (*aValue)
            NS_Free(*aValue);
        *aValue = ToNewUnicode(NS_ConvertUTF8toUTF16(aGValue));
    }
    g_free(aGValue);
    return NS_OK;
}

NS_IMETHODIMP
GtkPrompterService::PromptUsernameAndPassword(nsIDOMWindow* aParent,
                                              const PRUnichar* aDialogTitle,
                                              const PRUnichar* aDialogText,
                                              PRUnichar** aUsername,
                                              PRUnichar** aPassword,
                                              const PRUnichar* aCheckMsg,
                                              PRBool* aCheckValue,
                                              PRBool* aConfirm)
{
    gchar * aGUsername = ToNewCString(NS_ConvertUTF16toUTF8(*aUsername));
    gchar * aGPassword = ToNewCString(NS_ConvertUTF16toUTF8(*aPassword));

    g_signal_emit(G_OBJECT(gtk_moz_prompter_get()),
                  moz_prompter_signals[PROMPT_AUTH], 0,
                  GetGtkWidgetForDOMWindow(aParent),
                  NS_ConvertUTF16toUTF8(aDialogTitle).get(),
                  NS_ConvertUTF16toUTF8(aDialogText).get(),
                  &aGUsername,
                  &aGPassword,
                  NS_ConvertUTF16toUTF8(aCheckMsg).get(),
                  aCheckValue, aConfirm);

    if (*aConfirm) {
        if (*aUsername)
            NS_Free(*aUsername);
        *aUsername = ToNewUnicode(NS_ConvertUTF8toUTF16(aGUsername));

        if (*aPassword)
            NS_Free(*aPassword);
        *aPassword = ToNewUnicode(NS_ConvertUTF8toUTF16(aGPassword));
    }
    g_free(aGUsername);
    g_free(aGPassword);
    return NS_OK;
}

NS_IMETHODIMP
GtkPrompterService::PromptPassword(nsIDOMWindow* aParent,
                                   const PRUnichar* aDialogTitle,
                                   const PRUnichar* aDialogText,
                                   PRUnichar** aPassword,
                                   const PRUnichar* aCheckMsg,
                                   PRBool* aCheckValue, PRBool* aConfirm)
{
    gchar * aGPassword = ToNewCString(NS_ConvertUTF16toUTF8(*aPassword));

    g_signal_emit(G_OBJECT(gtk_moz_prompter_get()),
                  moz_prompter_signals[PROMPT_AUTH], 0,
                  GetGtkWidgetForDOMWindow(aParent),
                  NS_ConvertUTF16toUTF8(aDialogTitle).get(),
                  NS_ConvertUTF16toUTF8(aDialogText).get(),
                  NULL,
                  &aGPassword,
                  NS_ConvertUTF16toUTF8(aCheckMsg).get(),
                  aCheckValue, aConfirm);

    if (*aConfirm) {
        if (*aPassword)
            NS_Free(*aPassword);
        *aPassword = ToNewUnicode(NS_ConvertUTF8toUTF16(aGPassword));
    }
    g_free(aGPassword);
    return NS_OK;
}

NS_IMETHODIMP
GtkPrompterService::Select(nsIDOMWindow* aParent, const PRUnichar* aDialogTitle,
                           const PRUnichar* aDialogText, PRUint32 aCount,
                           const PRUnichar** aSelectList, PRInt32* outSelection,
                           PRBool* aConfirm)
{
    GList * list = NULL;

    nsCString *itemList = new nsCString[aCount];
    NS_ENSURE_TRUE(itemList, NS_ERROR_OUT_OF_MEMORY);

    for (PRUint32 i = 0; i < aCount; ++i) {
        itemList[i] = ToNewCString(NS_ConvertUTF16toUTF8(aSelectList[i]));
        list = g_list_append(list, (gpointer)itemList[i].get());
    }

    guint outselection = *outSelection;

    g_signal_emit(G_OBJECT(gtk_moz_prompter_get()),
                  moz_prompter_signals[SELECT], 0,
                  GetGtkWidgetForDOMWindow(aParent),
                  NS_ConvertUTF16toUTF8(aDialogTitle).get(),
                  NS_ConvertUTF16toUTF8(aDialogText).get(),
                  (const GList*)list, &outselection, aConfirm);

    *outSelection = outselection;

    delete[] itemList;
    g_list_free(list);
    return NS_OK;
}

const PRUint32 kButton0 = 0;
const PRUint32 kButton1 = 8;
const PRUint32 kButton2 = 16;

NS_IMETHODIMP
GtkPrompterService::CookieDialog(nsIDOMWindow *aParent, nsICookie *aCookie, const nsACString & aHostname,
                                 PRInt32 aCookiesFromHost, PRBool aChangingCookie, PRBool *aRememberDecision, PRInt32 *aRetval)
{
    NS_ENSURE_ARG_POINTER(aRememberDecision && aRetval);

    *aRememberDecision = PR_TRUE;          // "remember this decision" should be checked when we show the dialog
    PRInt32 buttonPressed = 0;

#if 0
    PRUnichar* textStr = ToNewUnicode(NS_LITERAL_STRING("CookieText"));
    PRUnichar* checkboxStr = ToNewUnicode(NS_LITERAL_STRING("CookieCheckbox"));
    PRUnichar* titleStr = ToNewUnicode(NS_LITERAL_STRING("CookieTitle"));
    PRUnichar* allowStr = ToNewUnicode(NS_LITERAL_STRING("AllowCookie"));
    PRUnichar* denyStr = ToNewUnicode(NS_LITERAL_STRING("DenyCookie"));
    PRUnichar* allowForSessionStr = ToNewUnicode(NS_LITERAL_STRING("Allow for Session"));

    long buttonFlags = (BUTTON_TITLE_IS_STRING << kButton0) | (BUTTON_TITLE_IS_STRING << kButton1) | (BUTTON_TITLE_IS_STRING << kButton2);
    ConfirmEx(aParent, titleStr, textStr, buttonFlags, allowStr, denyStr, allowForSessionStr, checkboxStr, aRememberDecision, &buttonPressed);
#else
    nsCString hostName(aHostname);
    nsCString aName, aValue, aDomain, aPath;
    aCookie->GetName(aName);
    aCookie->GetValue(aValue);
    aCookie->GetHost(aDomain);
    aCookie->GetPath(aPath);

    PRUint64 aExpires;
    aCookie->GetExpires(&aExpires);

    g_signal_emit_by_name(G_OBJECT(gtk_moz_prompter_get()),
                          "cookie-dialog",
                          GetGtkWidgetForDOMWindow(aParent),
                          aRememberDecision,
                          &buttonPressed,
                          (gulong)aExpires,
                          (const gchar *) hostName.get(),
                          (const gchar *) aName.get(),
                          (const gchar *) aValue.get(),
                          (const gchar *) aDomain.get(),
                          (const gchar *) aPath.get(), NULL);
#endif

    // map return values for nsICookiePromptService
    switch (buttonPressed)
    {
    case 0: // allow button
        *aRetval = nsICookiePromptService::ACCEPT_COOKIE;
        break;
    case 1: // deny button
        *aRetval = nsICookiePromptService::DENY_COOKIE;
        break;
    case 2: // allow for session button
        *aRetval = nsICookiePromptService::ACCEPT_SESSION_COOKIE;
        break;
    }

    return NS_OK;
}

