/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 tw=80 et cindent: */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is mozilla.org code.
 *
 * The Initial Developer of the Original Code is
 * Christopher Blizzard.
 * Portions created by the Initial Developer are Copyright (C) 2001
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Oleg Romashin <romaxa@gmail.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include "EmbedMicrobObserver.h"
#include "nsCOMPtr.h"
#include "nsICategoryManager.h"

// Clean auth info
#include "nsIHttpAuthManager.h"
#include "nsICookieManager.h"
#include "nsICookie2.h"
#include "nsNetCID.h"
#include "nsCRTGlue.h"

static NS_DEFINE_CID(kHttpAuthManagerCID,        NS_HTTPAUTHMANAGER_CID);   

nsresult
EmbedMicrobObserver::Create(nsISupports *aOuter, REFNSIID aIID, void **aResult)
{
  // g_critical("Func:%s::%d\n", __PRETTY_FUNCTION__, __LINE__);
  nsresult rv;

  if (aOuter) {
    rv = NS_ERROR_NO_AGGREGATION;
    return rv;
  }

  EmbedMicrobObserver* adapter = new EmbedMicrobObserver();
  if (!adapter) {
    rv = NS_ERROR_OUT_OF_MEMORY;
    return rv;
  }

  NS_ADDREF(adapter);
  rv = adapter->Init();
  if (NS_SUCCEEDED(rv)) {
    rv = adapter->QueryInterface(aIID, aResult);
  }
  NS_RELEASE(adapter);

  return rv;
}

nsresult
EmbedMicrobObserver::RegisterSelf(nsIComponentManager* aCompMgr,
                                    nsIFile* aPath,
                                    const char* aLoaderStr,
                                    const char* aType,
                                    const nsModuleComponentInfo *aInfo)
{
  // g_critical("Func:%s::%d\n", __PRETTY_FUNCTION__, __LINE__);
  nsresult rv;
  nsCOMPtr<nsICategoryManager> catMan = do_GetService(NS_CATEGORYMANAGER_CONTRACTID, &rv);
  if (!catMan) return NS_ERROR_FAILURE;

  rv = catMan->AddCategoryEntry("app-startup",
                                "EmbedMicrobObserver",
                                NS_EMBED_CLIENT_OBSERVER_CONTRACTID,
                                PR_TRUE, PR_TRUE, nsnull);
  return rv;
}

nsresult
EmbedMicrobObserver::UnregisterSelf(nsIComponentManager* aCompMgr,
                                      nsIFile* aPath,
                                      const char *registryLocation,
                                      const nsModuleComponentInfo *aInfo)
{
  // g_critical("Func:%s::%d\n", __PRETTY_FUNCTION__, __LINE__);
  nsresult rv;
  nsCOMPtr<nsICategoryManager> catMan = do_GetService(NS_CATEGORYMANAGER_CONTRACTID, &rv);
  if (!catMan) return NS_ERROR_FAILURE;

  rv = catMan->DeleteCategoryEntry("app-startup",
                                   "EmbedMicrobObserver",
                                   PR_TRUE);
  return rv;
}


EmbedMicrobObserver::EmbedMicrobObserver()
{
  // g_critical("Func:%s::%d\n", __PRETTY_FUNCTION__, __LINE__);
}

EmbedMicrobObserver::~EmbedMicrobObserver()
{
  // g_critical("Func:%s::%d\n", __PRETTY_FUNCTION__, __LINE__);
}

nsresult
EmbedMicrobObserver::Init()
{
  // g_critical("Func:%s::%d\n", __PRETTY_FUNCTION__, __LINE__);
  nsresult rv = NS_OK;
  return rv;
}

nsresult
EmbedMicrobObserver::CleanAuthData ()
{
    nsCOMPtr<nsIHttpAuthManager> authManager = do_GetService(kHttpAuthManagerCID);
    if (authManager)
        authManager->ClearAll();

    nsresult rv;
    nsCOMPtr<nsICookieManager> cookieManager =
        do_GetService(NS_COOKIEMANAGER_CONTRACTID, &rv);
    NS_ENSURE_SUCCESS(rv, rv);
    nsCOMPtr<nsISimpleEnumerator> cookieEnumerator;
    rv = cookieManager->GetEnumerator(getter_AddRefs(cookieEnumerator));
    NS_ENSURE_SUCCESS(rv, rv);
    PRBool enumResult;
    PRUint32 count = 0;
    PRUint32 count2 = 0;
    for (cookieEnumerator->HasMoreElements(&enumResult);
            enumResult == PR_TRUE;
            cookieEnumerator->HasMoreElements(&enumResult))
    {
        nsCOMPtr<nsICookie> nsCookie;
        nsCOMPtr<nsICookie2> nsCookie2;
        rv = cookieEnumerator->GetNext(getter_AddRefs(nsCookie));
        nsCookie2 = do_QueryInterface(nsCookie, &rv);
        PRBool aIsSession = PR_FALSE;
        if (NS_SUCCEEDED(rv) && nsCookie)
            nsCookie2->GetIsSession(&aIsSession);
        if (aIsSession) {
            nsCString host,path,name;
            nsCookie->GetHost(host);
            nsCookie->GetPath(path);
            nsCookie->GetName(name);
            cookieManager->Remove(host, name, path, PR_FALSE);
        }
    }
    return NS_OK;
}

NS_IMETHODIMP
EmbedMicrobObserver::Observe(nsISupports *aSubject, const char *aTopic, const PRUnichar *aData)
{
  // g_critical("Func:%s::%d, aTopic:%s\n", __PRETTY_FUNCTION__, __LINE__, aTopic);
  // BEGIN RESERVED DATA
  if (!strcmp(aTopic, "engine_clean_auth")) {
    return CleanAuthData();
  }
  else if (!strcmp(aTopic, "DOMLink_MAYBE_FEED")) {
    EmbedCommon *common = EmbedCommon::GetInstance();
    if (!common)
        return NS_OK;

    GtkMozEmbed* gme = common->GetAnyLiveWidget();
    if(!gme)
        return NS_OK;

    char *url, *title;

    if(aData)
        url = NS_strdup(NS_ConvertUTF16toUTF8(aData).get());
    else url = gtk_moz_embed_get_location(gme);

    title = gtk_moz_embed_get_title(gme);

    g_signal_emit(GTK_OBJECT(gme), 
                      moz_embed_signals[RSS_REQUEST], 0,
                      (gchar*)url,
                      (gchar*)title);
    if (url)
        NS_Free(url);
    if (title)
        NS_Free(title);
    //mXSLTransformed = PR_FALSE;
  }
  // END RESERVED DATA
  else {
    int retval = 0;
    EmbedCommon *common = EmbedCommon::GetInstance();
    if (common)
      g_signal_emit_by_name (G_OBJECT (common->mCommon), "on-service-notify", common->mCommon, aTopic, aData?NS_ConvertUTF16toUTF8(aData).get():nsnull, &retval);
  }
  return NS_OK;
}

NS_IMPL_ISUPPORTS1(EmbedMicrobObserver, nsIObserver)

