/*
 * linux/include/asm-arm/arch-omap/debug.h
 *
 * Interface for enabling debug functionalities on OMAP24XX
 *
 * Copyright (C) 2006 Nokia Corporation
 * Igor Stoppa <igor.stoppa@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef OMAP_SNAPSHOT_H
#define OMAP_SNAPSHOT_H

#include <asm/mach-types.h>

#define OMAP_SNAPSHOT_SIZE 500

typedef u32 snapshot_t[2];

void (*omap_snap_shot_ptr)(void);
void omap_snapshot_push_address(u32 address);
int omap_snapshot_pop_data(snapshot_t *read);

#endif
