/*
 * pc2400m_if_we.h
 *
 *
 * Copyright (C) 2007 Nokia Corporation
 * Author: Jouni Lappi <jouni.lappi@nokia.com>
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 */


#ifndef PC2400M_IF_WE_H
#define PC2400M_IF_WE_H

/*strings for custom events */
#define SCAN_COMPLETE           "SCAN_COMPLETE"
#define WIMAX_DISCONNECT        "DISCONNECT"
#define WIMAX_CONNECTED         "CONNECTED"
#define BS_HO                   "BS_HO"

/* WiMAX : WiMAX specific IOCTLs:
 *   - even numbered are set and odd get
 *   - set are only available to root */

/** network scanning start */
#define SIOCSIWIMAXSCAN		SIOCIWFIRSTPRIV
/** get results for network scanning */
#define SIOCGIWIMAXSCAN		SIOCIWFIRSTPRIV + 1
/** get NSP NOTE! this is only used as information element */
#define SIOCGIWNSP		SIOCIWFIRSTPRIV + 2
/** get NAP */
#define SIOCGIWNAP      	SIOCIWFIRSTPRIV + 3
/** EAP success indication to driver */
#define SIOCSIWEAPRESULT	SIOCIWFIRSTPRIV + 4
/** Get error code for last operation */
#define SIOCGIWERRORCODE	SIOCIWFIRSTPRIV + 5
/** Disconnect from nw */
#define SIOCSIWDISCONNECT	SIOCIWFIRSTPRIV + 6
/** Connect to nw */
#define SIOCSIWCONNECT		SIOCIWFIRSTPRIV + 7


/* Scanning request flags in iw_wimax_scan_req struct*/
#define IW_SCAN_THIS_NAP        	0x01  /*< WiMAX: Scan only this NAP */
#define IW_SCAN_NSPS			0x02  /*< Do we scan NSP */
#define IW_SCAN_INCLUDEVERBOSE_NAMES	0x04

/* Scanning result flags */
/** WiMAX: Scan completion flag */
#define IW_SCAN_COMPLETE                0x04

/* WiMAX maximum size for channel plan list */
#define IW_MAX_CHANNEL_PLAN_SIZE        256
enum eap_success {
	eap_false,
	eap_true
};
	
/* NAP length 32 bit */
#define NAP_LEN_OCTETS                  4

struct wmx_eap_result {
        /** TRUE if negotiation was successfully completed, FALSE otherwise */
	enum eap_success eap_bool;
        /** length of the array of bytes pointed to by p_msk */
        u16  msk_length;
#define MAX_MSK_SIZE 64
        /** pointer to an array of bytes containing the calculated MSK */
        char *p_msk;
};
/*
 *      WiMAX: channel plan structure a.k.a drv_search_limit
 */
struct iw_channel_plan
{
	u32 carrier_freq;
	u32 max_tx_power;
	enum drv_channel_bandwidth channel_bandwidth;
	enum drv_fft_size fft_size;
	u8 preamble[DRV_PREAMBLE_SIZE];
};

struct  iw_wimax_scan_req
{
        __u8            flags; /* reserved as padding; use zero, this may
                                * be used in the future for adding flags
                                * to request different scan behavior */

        __u8            num_channel_plans; /* num entries in channel_plan;
                                       * 0 = scan all allowed channels */

        /*
         * Optional parameters for changing the default scanning behavior.
         * These are based on the MLME-SCAN.request from IEEE Std 802.11.
         * TU is 1.024 ms. If these are set to 0, driver is expected to use
         * reasonable default values. min_channel_time defines the time that
         * will be used to wait for the first reply on each channel. If no
         * replies are received, next channel will be scanned after this. If
         * replies are received, total time waited on the channel is defined by
         * max_channel_time.
         */
	/* this struct is defined in pc2400m_drv_if.h */
        struct drv_search_plan  channel_plan[IW_MAX_CHANNEL_PLAN_SIZE];
};

typedef struct iw_param nap;            /* WiMAX: NAP ID */
typedef struct iw_param nsp;            /* WiMAX: NSP ID */
struct nap_id {
	u32 nap_n;
};
struct nsp_id {
	u32 nsp_n;
};
struct err_cod {
	enum wmx_error_code code;
};

/* externalization of the wireless extensions structure */
extern const struct iw_handler_def  pc2400m_we_handler_def;

/* declaration of the wireless statistics handler */
struct iw_statistics *pc2400m_get_wireless_stats(struct net_device *dev);
int pc2400m_we_scan_result(struct drv_ind_search *resp, 
			   struct net_device *dev);
void pc2400m_send_simple_event(struct net_device *dev, const char *str);

#endif /* PC2400M_IF_WE_H */
