/*
 * pc2400m_if_sysfs.c
 *
 *
 * Copyright (C) 2007 Nokia Corporation
 * Author: Jouni Lappi <jouni.lappi@nokia.com>
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 */


#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/device.h>

#include "pc2400m_com.h"
#include "pc2400m_drv_if.h"
#include "pc2400m_if_sysfs.h"
#include "pc2400m_if.h"
#include "pc2400m_drv.h"
#include "pc2400m_release.h"

/**
 * pc2400m_if_show_fw_version - outputs fw version related info
 * @dev: sys device
 * @attr: file attributes
 * @buf: buffer in user space
 */
static ssize_t pc2400m_if_show_fw_version(struct device *dev, 
					  struct device_attribute *attr,
					  char *buf)
{
	struct net_device *ndev;
        struct net_local *nl;
	int offset = 0;

	ndev = (struct net_device *)dev->driver_data;
	nl = netdev_priv(ndev);

	if (nl->if_status == UNINITIALIZED) offset +=  
		sprintf(buf + offset, "FW NOT UPLOADED\n");
	if (nl->if_status == INIT_DONE) offset +=
		sprintf(buf + offset, "INIT DONE\n");
	if (nl->if_status == CONNECTED) offset += 
		sprintf(buf + offset, "INIT DONE, CONNECTED\n");
	offset += sprintf(buf + offset, 
		"API_VRS=18\n");	
	offset += sprintf(buf + offset, 
		"FW_VRS=%s_%s\n",(char *)nl->fw_vrs,(char *)nl->hw_vrs);
	offset += sprintf(buf + offset,"REL_VRS=%s\n", RELEASE_VAL); 
	return offset;
}

/**
 * pc2400m_if_prod_test_read - reads from file
 * @dev: sys device
 * @attr: file attributes
 * @buf: buffer in user space
 */
static ssize_t pc2400m_if_prod_test_read(struct device *dev, 
					 struct device_attribute *attr,
					 char *buf)
{

	struct net_device *ndev;
        struct net_local *nl;

	ndev = (struct net_device *)dev->driver_data;
	nl = netdev_priv(ndev);


	if (!nl->pt_buffer) nl->pt_len = 0;
	if (nl->pt_len)
		memcpy(buf,nl->pt_buffer,nl->pt_len);	
	
	return nl->pt_len;

}

/**
 * pc2400m_if_prod_test_write - writes to file
 * @dev: sys device
 * @attr: file attributes
 * @buf: write buffer
 * @count: bytes to write
 */
static ssize_t pc2400m_if_prod_test_write(struct device *dev,
					  struct device_attribute *attr,
					  const char *buf, size_t count)
{

	struct drv_cmd cmd;
	struct net_device *ndev;
	char *databuf;

	ndev = (struct net_device *)dev->driver_data;

	if (!buf) {
		ERROR("sysfs null buf\n");		
		goto out;
	}
	databuf = kmalloc(count,GFP_KERNEL);
	if (!databuf) {
		ERROR("No mem for sysfs\n");
		goto out;
	}
	
	memcpy(databuf,buf,count);

	cmd.cmd_id = E_PROD_TEST;
	cmd.cmd.prod_test.data_length = count;
	cmd.cmd.prod_test.data = databuf;

	WIMAX_NO_WAIT_CMD(ndev, &cmd);
 out:
	return count;

}

static DEVICE_ATTR(fw_version, 
		   S_IRUGO | S_IWUSR, 
		   pc2400m_if_show_fw_version, 
		   NULL);
static DEVICE_ATTR(prod_testing, 
		   S_IRUGO | S_IWUSR, 
		   pc2400m_if_prod_test_read, 
		   pc2400m_if_prod_test_write);

/**
 * pc2400m_if_sysfs_create_files - creates sysfs files
 * @dev: sys device
 */
int pc2400m_if_sysfs_create_files(struct device *dev)
{

	int res;

	res = device_create_file(dev, &dev_attr_fw_version);
	res = device_create_file(dev, &dev_attr_prod_testing);

	return res;
}

/**
 * pc2400m_if_sysfs_uncreate_files - removes sysfs files
 * @dev: sys device
 */
void pc2400m_if_sysfs_uncreate_files(struct device *dev)
{

	device_remove_file(dev, &dev_attr_fw_version);
	device_remove_file(dev, &dev_attr_prod_testing);
}


