/*
 * pc2400m_drv_sllist.h
 *
 * Copyright (C) 2007 Nokia Corporation
 * Author: Juuso Oikarinen <juuso.oikarinen@nokia.com>
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 */


#ifndef PC2400M_DRV_SLLIST
#define PC2400M_DRV_SLLIST

struct sllist {
	struct sllist *next;
	struct sllist *last;
};

#define sllist_foreach(list, pos) \
	for(pos=list; pos; pos=pos->next)

#define sllist_init_elem(elem) { (elem)->last = (elem); (elem)->next = NULL; }

static inline void sllist_free(struct sllist **list, void (*freecb)(void*))
{
	struct sllist *pos;

	while (*list) {
		pos = *list;
		*list=(*list)->next;
		freecb((void*)pos);
	}
	*list = NULL;
	return;
}

static inline void sllist_append(struct sllist **list, struct sllist *elem)
{

	wimax_osal_assert(elem != NULL);

	if (*list) {
		(*list)->last->next = elem;
		(*list)->last = elem;
		elem->next = NULL;
	} else {
		(*list) = elem;
		elem->next = NULL;
		elem->last = elem;
	}
}

static inline void sllist_insert(struct sllist **list, struct sllist *elem)
{

	wimax_osal_assert(elem != NULL);

	if (*list) {
		elem->last = (*list)->last;
		elem->next = (*list);
		*list = elem;
	} else {
		*list = elem;
		elem->next = NULL;
		elem->last = elem;
	}
}

static inline struct sllist *sllist_pop(struct sllist **list)
{

	struct sllist *elem = NULL;

	if (*list) {
		elem = *list;
		*list = elem->next;
		if (*list) (*list)->last = elem->last;
	}
	
	return elem;

}






#endif /* PC2400M_DRV_SLLIST */
