/*
 * pc2400m_drv_dm.h
 *
 * Copyright (C) 2007 Nokia Corporation
 * Author: Juuso Oikarinen <juuso.oikarinen@nokia.com>
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 */



#ifndef PC2400M_DRV_DM_H
#define PC2400M_DRV_DM_H

#include "pc2400m_osal.h"
#include "pc2400m_drv_if.h"

struct pc2400m_drv_dm_if;
struct pc2400m_drv_cd_if;
struct pc2400m_drv_hdi_if;

/* transition identifiers */
enum pc2400m_drv_dm_transitions {
	PC2400M_DRV_DM_GET_DEVICE_INFO = 0,
	PC2400M_DRV_DM_ENABLE_RADIO,
	PC2400M_DRV_DM_DISABLE_RADIO,
	PC2400M_DRV_DM_START_SCAN,
	PC2400M_DRV_DM_STOP_SCAN,
	PC2400M_DRV_DM_CONNECT,
	PC2400M_DRV_DM_DISCONNECT,
	PC2400M_DRV_DM_INIT,
	PC2400M_DRV_DM_TERMINATE,
	PC2400M_DRV_DM_PRODUCTION,
	PC2400M_DRV_DM_SUSPEND,
	PC2400M_DRV_DM_RESUME,
};

/* transition parameters */
struct pc2400m_drv_dm_connect_params {
	struct drv_cmd_entry req;
};

struct pc2400m_drv_dm_start_scan_params {
	struct drv_cmd_search req;
};


/* dm functions */
typedef void (*dm_reset_func)(struct pc2400m_drv_dm_if*);
typedef void (*dm_cleanup_func)(struct pc2400m_drv_dm_if*);
typedef void (*dm_initialize_cb)(struct pc2400m_drv_dm_if*, s32, void*);
typedef void (*dm_initialize_func)(struct pc2400m_drv_dm_if*, 
				   u8*, u32, dm_initialize_cb, void*);
typedef s32 (*dm_abort_mission_func)(struct pc2400m_drv_dm_if*);
typedef void (*dm_transition_cb)(struct pc2400m_drv_dm_if*, s32, 
				 void*, void*, void*);
typedef void (*dm_transition_func)(struct pc2400m_drv_dm_if*,
				  enum pc2400m_drv_dm_transitions,
				  void*, dm_transition_cb, void*, void*);
typedef s32 (*dm_get_capabilities_func)(struct pc2400m_drv_dm_if*,u8*,u8*,u8*);
typedef s32 (*dm_get_link_state_func)(struct pc2400m_drv_dm_if*);
typedef u8* (*dm_get_tlv_func)(struct pc2400m_drv_dm_if*, u8*, u16, u8*);
typedef void (*dm_setup_header_func)(struct pc2400m_drv_dm_if*, u8*, u16, u16);

/* structure to hold the chipset state cache */
struct pc2400m_drv_dm_chipset {
	struct {
		u16 L4Mversion[3];
		u8 hw_version[DRV_VERSION_STR_LEN];
		u8 fw_version[DRV_VERSION_STR_LEN];
#define DM_MAC_ADDR_LEN 6
		u8 mac_addr[DM_MAC_ADDR_LEN];
		u8 set;
	} cap;
	struct {
		u8 bs_id[DRV_BSID_LENGTH];
		u8 rssi;
		u8 up;
		u8 set;
	} link;
        struct {
	        boolean hw_switch;
	} rf;
	struct {
		enum drv_status disconnect_status;
	} trans;
	u8 state;
};

/* structure representing the control dispatcher */
struct pc2400m_drv_dm_if {
	wimax_osal_context *ctx;
	dm_cleanup_func cleanup;
	dm_reset_func reset;
	dm_initialize_func initialize;
	dm_abort_mission_func abort_mission;
	dm_transition_func transition;
	dm_get_capabilities_func get_capabilities;
	dm_get_link_state_func get_link_state;
	dm_get_tlv_func get_tlv;
	dm_setup_header_func setup_header;

	/* instance variables */
	struct pc2400m_drv_cd_if *cd;
	struct pc2400m_drv_hdi_if *hdi;

	/* dm state flags */
#define PC2400M_DRV_DM_FLAGS_SUSPENDED 0x00000001
	u32 flags;

	/* system state */
	u32 state;

	/* transition queue */
	struct sllist *transq;

	/* current transition information */
	struct pc2400m_drv_dm_trans *trans;

	/* chipset state information */
	struct pc2400m_drv_dm_chipset chipset;

};

/* dm instantiator function */
struct pc2400m_drv_dm_if *pc2400m_drv_dm_if_new(wimax_osal_context* ctx);


#endif /* PC2400M_DRV_DM_H */
