/*
 * pc2400m_com.h
 *
 * Copyright (C) 2007 Nokia Corporation
 * Author: Juuso Oikarinen <juuso.oikarinen@nokia.com>
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 */


#ifndef PC2400M_COM_H
#define PC2400M_COM_H


#include <linux/kernel.h>
#include <linux/netdevice.h>
#include <linux/skbuff.h>
#include <asm/semaphore.h>
#include "pc2400m_spi.h"

#define DRV_SUFFIX "PC2400M: "

#define DEBUG(x...) printk(KERN_DEBUG DRV_SUFFIX x)
#define ERROR(x...) printk(KERN_ERR DRV_SUFFIX x)
#define INFO(x...)  printk(KERN_INFO DRV_SUFFIX x)

/**
 * Global variable holding the currently executing context. This is only
 * valid within the common driver. */
extern struct net_device *pc2400m_com_running_context;

/**
 * Global lock for the adaptation library. This is global, because the driver
 * lib needs to be concurrency protected from multiple accesses regardless
 * of the number of instances with one single lock. */
extern struct semaphore pc2400m_com_mutex;

/**
 * pc2400m_com_lock - get a global lock
 *
 * Get a global lock to protect the driver library
 * from concurrent access
 */

static inline void pc2400m_com_lock(struct net_device *ndev) {

	down(&pc2400m_com_mutex);
	pc2400m_com_running_context = ndev;
}

/**
 * pc2400m_com_unlock - release the global lock
 *
 * Release the global lock used to protect the driver
 * library from concurrent access
 */

static inline void pc2400m_com_unlock(void) {

	pc2400m_com_running_context = NULL;
	up(&pc2400m_com_mutex);

}

#endif /* PC2400M_COM_H */
