/*
 * This file is part of hello-world-app
 *
 * Copyright (C) 2006-2008 Nokia Corporation. All rights reserved.
 *
 * This maemo code example is licensed under a MIT-style license,
 * that can be found in the file called "COPYING" in the package
 * root directory.
 *
 */

#include <glib/gmem.h>
#include <gtk/gtkmenu.h>
#include <gtk/gtkmenuitem.h>
#include <gtk/gtkmessagedialog.h>
#include <gtk/gtkbutton.h>
#include <gtk/gtkmain.h>

#include <string.h>

#include <gtk/gtk.h>

#include <libhildondesktop/libhildondesktop.h>

#include "hello-world-tn.h"

HD_DEFINE_PLUGIN (HelloNavigatorPlugin, hello_navigator_plugin, TASKNAVIGATOR_TYPE_ITEM);

GtkWidget *
hello_world_button_new (int padding)
{
  GtkIconTheme *icon_theme;
  GdkPixbuf *icon;
  GtkWidget *icon_image, *button;

  icon_theme = gtk_icon_theme_get_default ();
  icon = gtk_icon_theme_load_icon (icon_theme,
				   "hello-world",
				   40,
				   0,
				   NULL);
  if (icon == NULL)
    icon = gtk_icon_theme_load_icon (icon_theme,
				     "qgn_list_gene_default_app",
				     40,
				     0,
				     NULL);
    
  icon_image = gtk_image_new_from_pixbuf (icon);
  gtk_misc_set_padding (GTK_MISC (icon_image), padding, padding);
  g_object_unref (G_OBJECT (icon));
  button = gtk_button_new ();
  gtk_container_add (GTK_CONTAINER (button), icon_image);

  gtk_widget_show_all (button);

  return button;
}

static void
show_dialog (GtkWidget *item, HelloNavigatorPlugin *thw)
{
    GtkWidget *dialog;
    dialog = gtk_message_dialog_new (NULL,
                                     GTK_DIALOG_MODAL | 
                                        GTK_DIALOG_DESTROY_WITH_PARENT,
                                     GTK_MESSAGE_INFO,
                                     GTK_BUTTONS_CLOSE,
                                     "Hello world!");

    gtk_window_set_title (GTK_WINDOW(dialog), "TN Plugin Example");    
    gtk_dialog_run (GTK_DIALOG (dialog));
    gtk_widget_destroy (dialog);
}

static void
menu_position (GtkMenu *menu,
               gint *x,
               gint *y,
               gboolean *push_in,
               HelloNavigatorPlugin *thw)
{
    g_return_if_fail (thw->button);
    *push_in = TRUE;

    *x = thw->button->allocation.x + thw->button->allocation.width;
    *y = thw->button->allocation.y;
}

static void
popup_menu (GtkWidget *button, HelloNavigatorPlugin *plugin)
{
    if (!plugin->menu)
        return;

    gtk_menu_popup (GTK_MENU (plugin->menu),
                    NULL,
                    NULL,
                    (GtkMenuPositionFunc)menu_position,
                    plugin,
                    0,
                    gtk_get_current_event_time());
}

static GtkWidget*
create_menu (void)
{
    GtkWidget  *menu;
    GtkWidget  *menu_item;

    menu = gtk_menu_new ();

    menu_item = gtk_menu_item_new_with_label ("Hello World!");
    g_signal_connect (G_OBJECT (menu_item), "activate",
                      G_CALLBACK (show_dialog), NULL);

    gtk_menu_append (menu, menu_item);

    /* Name the menu to get the appropriate theming */
    gtk_widget_set_name (menu, "menu_from_navigator");

    gtk_widget_show_all (menu);

    return menu;
}

static void
hello_navigator_plugin_init (HelloNavigatorPlugin *navigator_plugin)
{
  GtkWidget *button;

//  button = gtk_button_new_with_label ("HW");
  button = hello_world_button_new (10);
  navigator_plugin->button=button;
  navigator_plugin->menu=create_menu();
  //gtk_button_set_image (GTK_BUTTON (button), gtk_image_new_from_stock (GTK_STOCK_CONVERT, GTK_ICON_SIZE_LARGE_TOOLBAR));
  
  g_signal_connect (G_OBJECT (button), "clicked",
                      G_CALLBACK (popup_menu), navigator_plugin);
  
  gtk_widget_set_size_request (button, 80, 80);
  gtk_widget_set_name (button, "hildon-navigator-button-one");

  gtk_widget_show_all (button);

  gtk_container_add (GTK_CONTAINER (navigator_plugin), button);
  gtk_widget_show_all (navigator_plugin);
}

static void
hello_navigator_plugin_class_init (HelloNavigatorPluginClass *class)
{
}
