/*
 * This file is part of hello-world-app
 *
 * Copyright (C) 2006-2008 Nokia Corporation. All rights reserved.
 *
 * This maemo code example is licensed under a MIT-style license,
 * that can be found in the file called "COPYING" in the package
 * root directory.
 *
 */

#ifndef _HILDON_STATUS_BAR_HELLOWORLD_H_
#define _HILDON_STATUS_BAR_HELLOWORLD_H_

/* StatusbarItem */
#include <libhildondesktop/statusbar-item.h>

/* osso_context_t */
#include <libosso.h>

/* gboolean, gint, G_BEGIN_DECLS/G_END_DECLS */
#include <glib.h>

/* GtkWidget */
#include <gtk/gtk.h>

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

G_BEGIN_DECLS

/* Every plugin has a constant priority */
#define HILDON_STATUS_BAR_HELLOWORLD_PRIORITY	1

#define HILDON_STATUS_BAR_HELLOWORLD_ICON_SIZE	40

typedef struct _HildonStatusBarHelloWorld HildonStatusBarHelloWorld;
typedef struct _HildonStatusBarHelloWorldClass HildonStatusBarHelloWorldClass;

#define HILDON_TYPE_STATUS_BAR_HELLOWORLD            (hildon_status_bar_helloworld_get_type ())
#define HILDON_STATUS_BAR_HELLOWORLD(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), DUMMY_TYPE_STATUS_BAR_HELLOWORLD, HildonStatusBarHelloWorld))
#define HILDON_STATUS_BAR_HELLOWORLD_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass),  DUMMY_TYPE_STATUS_BAR_HELLOWORLD, HildonStatusBarHelloWorldClass))
#define HILDON_IS_STATUS_BAR_HELLOWORLD(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DUMMY_TYPE_STATUS_BAR_HELLOWORLD))
#define HILDON_IS_STATUS_BAR_HELLOWORLD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),  DUMMY_TYPE_STATUS_BAR_HELLOWORLD))
#define HILDON_STATUS_BAR_HELLOWORLD_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj),  DUMMY_TYPE_STATUS_BAR_HELLOWORLD, HildonStatusBarHelloWorldClass))

struct _HildonStatusBarHelloWorld
{
    StatusbarItem parent;
};

struct _HildonStatusBarHelloWorldClass
{
    StatusbarItemClass parent_class;
};

GType hildon_status_bar_helloworld_get_type(void);

typedef struct
{
    osso_context_t       *osso;		/* osso */
    GtkWidget            *icon;		/* icon in button */
    GtkWidget		 *button;	/* button in StatusBar */
} HildonStatusBarHelloWorldPrivate;

G_END_DECLS

#endif /* _HILDON_STATUS_BAR_HELLOWORLD_H_ */
