/*
 * This file is part of hello-world-app
 *
 * Copyright (C) 2006-2008 Nokia Corporation. All rights reserved.
 *
 * This maemo code example is licensed under a MIT-style license,
 * that can be found in the file called "COPYING" in the package
 * root directory.
 *
 */

/* Hildon includes */
#include <hildon/hildon-note.h>
#include <hildon/hildon-banner.h>
#include <hildon/hildon-sound.h>
#include <hildon/hildon-defines.h>
#include <libhildondesktop/libhildondesktop.h>

#include <log-functions.h>
#include <libosso.h>
#include <osso-log.h>

/* GTK includes */
#include <glib.h>
#include <gtk/gtk.h>
#include <gdk/gdkpixbuf.h>

/* Systems includes */
#include <string.h>

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "hello-world-statusbar.h"
#include "libhelloworld.h"

HD_DEFINE_PLUGIN(HildonStatusBarHelloWorld,
		 hildon_status_bar_helloworld,
	       	 STATUSBAR_TYPE_ITEM);

#define HILDON_STATUS_BAR_HELLOWORLD_GET_PRIVATE(x) \
	    (G_TYPE_INSTANCE_GET_PRIVATE((x), \
                                         hildon_status_bar_helloworld_get_type(), \
                                         HildonStatusBarHelloWorldPrivate));

static void hildon_status_bar_helloworld_finalize(GObject *object);

static void hildon_status_bar_helloworld_class_init(
		HildonStatusBarHelloWorldClass *klass)
{
    GObjectClass *object_class = G_OBJECT_CLASS(klass);
    object_class->finalize = hildon_status_bar_helloworld_finalize;
    g_type_class_add_private(klass, sizeof(HildonStatusBarHelloWorldPrivate));
}

static void set_helloworld_icon(const gchar *name, HildonStatusBarHelloWorldPrivate *info)
{
    GtkIconTheme *icon_theme;
    GdkPixbuf    *pixbuf;

    icon_theme = gtk_icon_theme_get_default();

    pixbuf = (name != NULL) ? gtk_icon_theme_load_icon(icon_theme, name,
                                                       HILDON_STATUS_BAR_HELLOWORLD_ICON_SIZE,
                                                       GTK_ICON_LOOKUP_NO_SVG, NULL) : NULL;

    gtk_image_set_from_pixbuf(GTK_IMAGE(info->icon), pixbuf);

    if (pixbuf != NULL)
        g_object_unref(pixbuf);
}

static void hildon_status_bar_helloworld_finalize(GObject *object)
{
    HildonStatusBarHelloWorldPrivate *info = HILDON_STATUS_BAR_HELLOWORLD_GET_PRIVATE(object);

    osso_deinitialize(info->osso);

    LOG_CLOSE();

    G_OBJECT_CLASS(g_type_class_peek_parent(G_OBJECT_GET_CLASS(object)))->finalize(object);
}

static void hildon_status_bar_helloworld_init(HildonStatusBarHelloWorld *helloworld)
{
    HildonStatusBarHelloWorldPrivate *info = 
        HILDON_STATUS_BAR_HELLOWORLD_GET_PRIVATE(helloworld);

    ULOG_OPEN("hildon-sb-helloworld");

    g_return_if_fail(info);

    info->icon = gtk_image_new_from_pixbuf(NULL);
    info->button = gtk_toggle_button_new();

    set_helloworld_icon("hello-world", info);

    gtk_container_add(GTK_CONTAINER(info->button),
                      GTK_WIDGET(info->icon));

    gtk_container_add(GTK_CONTAINER(helloworld), info->button);

    /* Signal for icon (button) */
    g_signal_connect(G_OBJECT(info->button), "button-press-event",
                     G_CALLBACK(hello_world_dialog_show), NULL);

    /* Initialize osso */
    info->osso = osso_initialize("hildon_sb_helloworld", "1.0", FALSE, NULL);
    if (!info->osso)
        ULOG_WARN("%s: error while initializing osso\n", __FUNCTION__);

    gtk_widget_show_all(GTK_WIDGET(helloworld));
}
