/*
 * This file is part of libgst0.10-dsp
 *
 * Copyright (C) 2006 Nokia Corporation. All rights reserved.
 *
 * Contact: Stefan Kost <stefan.kost@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef __GST_OMAPDSP__H__
#define __GST_OMAPDSP_H__


enum
{
  DSP_MODE_UNINITIALIZED, /* DSP is just opened                      */
  DSP_MODE_INITIALIZED,   /* DSP_CMD_INIT has been sent to DSP       */
  DSP_MODE_CONFIGURED,    /* DSP_CMD_SET_PARAMS has been sent to DSP */
  DSP_MODE_PLAYING,       /* DSP_CMD_PLAY has been sent to DSP       */
  DSP_MODE_PAUSED,        /* DSP_CMD_PAUSE has been sent to DSP      */
  DSP_MODE_STOPPED,       /* DSP_CMD_STOP has been sent to DSP       */
  DSP_MODE_EOS,           /* DSP_CMD_EOF has been sent to DSP        */
  DSP_MODE_RESET,         /* Recoverable error occured, reset needed */
  DSP_MODE_ERROR          /* Non-recoverable error occured           */
};

/* Generic DSP data write structure */
typedef struct dsp_data_write
{
  unsigned short int dsp_cmd;
  unsigned short int data_size;
} DSP_DATA_WRITE;


#define OMAP_DSP_TASK_IOCTL_LOCK        0x10002
#define OMAP_DSP_TASK_IOCTL_UNLOCK      0x10003

#endif
