/*
 * This file is part of libgst0.10-dsp
 *
 * Copyright (C) 2007 Nokia Corporation. All rights reserved.
 *
 * Contact: Stefan Kost <stefan.kost@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef __GST_DSPMIXER_H__
#define __GST_DSPMIXER_H__

#include <gst/interfaces/mixer.h>

G_BEGIN_DECLS


#define GST_IMPLEMENT_DSPMIXER_METHODS(Type, interface_as_function)             \
static gboolean                                                                 \
interface_as_function ## _mixer_supported (GstImplementsInterface *iface,       \
    GType iface_type)                                                           \
{                                                                               \
  g_assert (iface_type == GST_TYPE_MIXER);                                      \
  return TRUE;                                                                  \
}                                                                               \
                                                                                \
static void                                                                     \
interface_as_function ## _interface_init (GstImplementsInterfaceClass * klass)  \
{                                                                               \
  klass->supported = interface_as_function ## _mixer_supported;                 \
}                                                                               \
                                                                                \
static const GList*                                                             \
interface_as_function ## _mixer_list_tracks (GstMixer * mixer)                  \
{                                                                               \
  Type *this = (Type*) mixer;                                                   \
  GST_INFO(__FUNCTION__);                                                       \
                                                                                \
  g_return_val_if_fail (this != NULL, NULL);                                    \
  g_return_val_if_fail (this->audio != NULL, NULL);                             \
                                                                                \
  return gst_dspaudio_create_track_list(this->audio);                           \
}                                                                               \
                                                                                \
static void                                                                     \
interface_as_function ## _mixer_set_volume (GstMixer * mixer,                   \
    GstMixerTrack * track,                                                      \
    gint * volumes)                                                             \
{                                                                               \
  Type *this = (Type*) mixer;                                                   \
  GST_INFO(__FUNCTION__);                                                       \
                                                                                \
  g_return_if_fail (this != NULL);                                              \
  g_return_if_fail (this->audio != NULL);                                       \
                                                                                \
  GValue value = {0,};                                                          \
  g_value_init(&value, G_TYPE_UINT);                                            \
  g_value_set_uint(&value, (guint) volumes[0]);                                 \
  gst_dspaudio_set_property (this->audio, DSPAUDIO_PROP_VOLUME, &value);        \
}                                                                               \
                                                                                \
static void                                                                     \
interface_as_function ## _mixer_get_volume (GstMixer * mixer,                   \
    GstMixerTrack * track,                                                      \
    gint * volumes)                                                             \
{                                                                               \
  Type *this = (Type*) mixer;                                                   \
  GST_INFO(__FUNCTION__);                                                       \
                                                                                \
  g_return_if_fail (this != NULL);                                              \
  g_return_if_fail (volumes != NULL);                                           \
  g_return_if_fail (this->audio != NULL);                                       \
                                                                                \
  GValue value = {0,};                                                          \
  g_value_init(&value, G_TYPE_UINT);                                            \
  gst_dspaudio_get_property (this->audio, DSPAUDIO_PROP_VOLUME, &value);        \
  volumes[0] = (gint) g_value_get_uint(&value);                                 \
}                                                                               \
                                                                                \
static void                                                                     \
interface_as_function ## _mixer_set_mute (GstMixer * mixer,                     \
    GstMixerTrack * track,                                                      \
    gboolean mute)                                                              \
{                                                                               \
  Type *this = (Type*) mixer;                                                   \
  GST_INFO(__FUNCTION__);                                                       \
                                                                                \
  g_return_if_fail (this != NULL);                                              \
  g_return_if_fail (this->audio != NULL);                                       \
                                                                                \
  GValue value = {0,};                                                          \
  g_value_init (&value, G_TYPE_BOOLEAN);                                        \
  g_value_set_boolean (&value, mute);                                           \
  gst_dspaudio_set_property (this->audio, DSPAUDIO_PROP_MUTE, &value);          \
}                                                                               \
                                                                                \
static void                                                                     \
interface_as_function ## _mixer_interface_init (GstMixerClass * klass)          \
{                                                                               \
  GST_MIXER_TYPE (klass) = GST_MIXER_HARDWARE;                                  \
  GST_INFO(__FUNCTION__);                                                       \
                                                                                \
  /* set up the interface hooks */                                              \
  klass->list_tracks = interface_as_function ## _mixer_list_tracks;             \
  klass->set_volume = interface_as_function ## _mixer_set_volume;               \
  klass->get_volume = interface_as_function ## _mixer_get_volume;               \
  klass->set_mute = interface_as_function ## _mixer_set_mute;                   \
}


G_END_DECLS


#endif /* __GST_DSPMIXER_H__ */
