/*
 * This file is part of libgst0.10-dsp
 *
 * Copyright (C) 2007 Nokia Corporation. All rights reserved.
 *
 * Contact: Stefan Kost <stefan.kost@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


#ifndef __GST_DSPILBCSINK_H__
#define __GST_DSPILBCSINK_H__

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <gst/gst.h>
#include <gst/base/gstbasesink.h>

#include <dspaudio.h>

G_BEGIN_DECLS


#define GST_TYPE_DSPILBCSINK            (gst_dspilbcsink_get_type())
#define GST_DSPILBCSINK(obj)            (G_TYPE_CHECK_INSTANCE_CAST((obj),GST_TYPE_DSPILBCSINK,GstDSPILBCSink))
#define GST_DSPILBCSINK_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass),GST_TYPE_DSPILBCSINK,GstDSPILBCSinkClass))
#define GST_IS_DSPILBCSINK(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj),GST_TYPE_DSPILBCSINK))
#define GST_IS_DSPILBCSINK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass),GST_TYPE_DSPILBCSINK))

#define SID_FRAME_NO_UPDATE       0           /* SID params no update        */
#define VOICE_FRAME               1           /* data is encoded speech      */
#define SID_FRAME_UPDATE          2           /* SID params to be updated    */


typedef struct _GstDSPILBCSink GstDSPILBCSink;
typedef struct _GstDSPILBCSinkClass GstDSPILBCSinkClass;

struct _GstDSPILBCSink {
  GstBaseSink   sink;
  GstDSPAudio     *audio;
  guint           framesize;
  gint            mode;
};

struct _GstDSPILBCSinkClass {
  GstBaseSinkClass parent_class;
};

GType gst_dspilbcsink_get_type(void);

gboolean gst_dspilbcsink_factory_init (GstElementFactory *factory);

G_END_DECLS

#endif /* __GST_DSPILBCSINK_H__ */
