/*
 * This file is part of libgst0.10-dsp
 *
 * Copyright (C) 2006 Nokia Corporation. All rights reserved.
 *
 * Contact: Stefan Kost <stefan.kost@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


#ifndef __GST_DSPG729SINK_H__
#define __GST_DSPG729SINK_H__

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <gst/gst.h>
#include <gst/base/gstbasesink.h>

#include <dspaudio.h>

G_BEGIN_DECLS


#define GST_TYPE_DSPG729SINK            (gst_dspg729sink_get_type())
#define GST_DSPG729SINK(obj)            (G_TYPE_CHECK_INSTANCE_CAST((obj),GST_TYPE_DSPG729SINK,GstDSPG729Sink))
#define GST_DSPG729SINK_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass),GST_TYPE_DSPG729SINK,GstDSPG729SinkClass))
#define GST_IS_DSPG729SINK(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj),GST_TYPE_DSPG729SINK))
#define GST_IS_DSPG729SINK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass),GST_TYPE_DSPG729SINK))


typedef struct _GstDSPG729Sink GstDSPG729Sink;
typedef struct _GstDSPG729SinkClass GstDSPG729SinkClass;

struct _GstDSPG729Sink {
  GstBaseSink  sink;
  GstDSPAudio  *audio;
  short int    *mmap_ptr;
  guint8       lastcn[2];
};

struct _GstDSPG729SinkClass {
  GstBaseSinkClass parent_class;
};

GType gst_dspg729sink_get_type(void);

gboolean gst_dspg729sink_factory_init (GstElementFactory *factory);

G_END_DECLS

#endif /* __GST_DSPG729SINK_H__ */
