/*
 * This file is part of libgst0.10-dsp
 *
 * Copyright (C) 2006 Nokia Corporation. All rights reserved.
 *
 * Contact: Stefan Kost <stefan.kost@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


#ifndef __GST_DSPG711RC_H__
#define __GST_DSPG711SRC_H__

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <gst/gst.h>
#include <gst/base/gstpushsrc.h>

#include <dspaudio.h>

G_BEGIN_DECLS

#define GST_TYPE_DSPG711SRC            (gst_dspg711src_get_type())
#define GST_DSPG711SRC(obj)            (G_TYPE_CHECK_INSTANCE_CAST((obj),GST_TYPE_DSPG711SRC,GstDSPG711Src))
#define GST_DSPG711SRC_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass),GST_TYPE_DSPG711SRC,GstDSPG711SrcClass))
#define GST_IS_DSPG711SRC(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj),GST_TYPE_DSPG711SRC))
#define GST_IS_DSPG711SRC_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass),GST_TYPE_DSPG711SRC))

typedef struct _GstDSPG711Src GstDSPG711Src;
typedef struct _GstDSPG711SrcClass GstDSPG711SrcClass;

struct _GstDSPG711Src {
  GstPushSrc      parent;
  GstDSPAudio     *audio;
  GstClock        *clock;
  GstPad          *cnpad;
};

struct _GstDSPG711SrcClass {
  GstPushSrcClass parent_class;
};


GType gst_dspg711src_get_type(void);

G_END_DECLS

#endif /* __GST_DSPG711SRC_H__ */
