/*
 * This file is part of libgst0.10-dsp
 *
 * Copyright (C) 2006 Nokia Corporation. All rights reserved.
 *
 * Contact: Stefan Kost <stefan.kost@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


#ifndef __GST_DSPAACSINK_H__
#define __GST_DSPAACSINK_H__

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <gst/gst.h>
#include <gst/base/gstbasesink.h>
#include <gst/base/gstadapter.h>

#include <dspaudio.h>
#ifdef HAVE_DSP_H
#include <dsp/interface_common.h>
#include <dsp/aac_dsptask.h>
#endif


G_BEGIN_DECLS


#define GST_TYPE_DSPAACSINK            (gst_dspaacsink_get_type())
#define GST_DSPAACSINK(obj)            (G_TYPE_CHECK_INSTANCE_CAST((obj),GST_TYPE_DSPAACSINK,GstDSPAACSink))
#define GST_DSPAACSINK_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass),GST_TYPE_DSPAACSINK,GstDSPAACSinkClass))
#define GST_IS_DSPAACSINK(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj),GST_TYPE_DSPAACSINK))
#define GST_IS_DSPAACSINK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass),GST_TYPE_DSPAACSINK))

enum {
  DSPAAC_HEADER_NOT_PARSED,
  DSPAAC_HEADER_UNKNOWN,
  DSPAAC_HEADER_ADIF,
  DSPAAC_HEADER_ADTS,
  DSPAAC_HEADER_NONE
};


typedef struct _GstDSPAACSink GstDSPAACSink;
typedef struct _GstDSPAACSinkClass GstDSPAACSinkClass;

struct _GstDSPAACSink {
  GstBaseSink   sink;
  GstDSPAudio    *audio;
  GstAdapter     *adapter;
  GstClock       *clock;

  // Stream type -related info
  gint           object_type;
  gint           bitrate;
  gint           sample_rate;
  gint           channels;
  guint          header_type;
  guint          preroll_skipped;
  guint64        bytes_written;
  gboolean       sync;
  gboolean       got_stream_info;
  GstClockTime   seek_basetime;
  GstClockTime   dsp_basetime;
};

struct _GstDSPAACSinkClass {
  GstBaseSinkClass parent_class;
};

GType gst_dspaacsink_get_type(void);

gboolean gst_dspaacsink_factory_init (GstElementFactory *factory);

G_END_DECLS

#endif /* __GST_DSPAACSINK_H__ */
