/*
 * This file is part of eds-sync
 *
 * Copyright (C) 2007 Nokia Corporation. All rights reserved.
 *
 * Author: Ross Burton <ross@openedhand.com>
 * Author: Onne Gorter <onne.gorter@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef _UTIL_H
#define _UTIL_H

#include <time.h>
#include <glib.h>
#include <libtelepathy/tp-conn.h>
#include <libebook/e-book.h>

G_BEGIN_DECLS

/* Only check for one of these, they generally all exist or not */
#ifndef EVC_X_OSSO_CONTACT_STATE
#define EVC_X_OSSO_CONTACT_STATE "X-OSSO-CONTACT-STATE"
#define EVC_X_OSSO_FIELD_STATE "X-OSSO-FIELD-STATE"
#define EVC_X_OSSO_BOUND "X-OSSO-BOUND"
#define EVC_X_OSSO_LAST_USED "X-OSSO-LAST-USED"
#endif

#define _ERROR_MSG(err) ((err) ? (err)->message : "0xdeadbeef")

typedef enum {
  CONTACT_STATE_AUTOMATIC,
  CONTACT_STATE_ADDED,
  CONTACT_STATE_BLOCKED,
  CONTACT_STATE_DELETED,
  CONTACT_STATE_MANUAL,
} ContactState;

typedef enum {
  FIELD_STATE_TOADD,
  FIELD_STATE_TODELETE,
  FIELD_STATE_TOBLOCK,
  FIELD_STATE_TOUNBLOCK,
  FIELD_STATE_BLOCKED
} FieldState;

gboolean inspect_handle (TpConn *conn, const guint handle, const char **username, GError **error);

void remove_handle_cache (TpConn *conn, const guint handle);

gboolean eds_tp_conn_inspect_handle (DBusGProxy *proxy, const guint IN_handle_type, const guint IN_handle, char ** OUT_arg2, GError **error);

gboolean eds_tp_conn_request_handle (DBusGProxy *proxy, const guint IN_handle_type, const char * IN_name, guint *OUT_arg2, GError **error);

void print_handle (guint i, TpConn *conn);

gboolean contact_state_is (EContact *contact, const ContactState state);
void contact_state_remove (EContact *contact, const ContactState state);

gboolean field_state_is (EVCardAttribute *attr, const FieldState state);
void field_state_remove (EVCardAttribute *attr, const FieldState state);
void field_state_set    (EVCardAttribute *attr, const FieldState state);

gboolean attribute_is_bound_to (EVCardAttribute *attr, const char *bound);

void set_contact_flag (EContact   *contact, const char *flag, gboolean flag_set);

guint queue_avatar_cache_expire (gpointer data, GDestroyNotify destroy);

time_t get_last_used (EContact *contact);

G_END_DECLS

#endif /* _UTIL_H */
