/*
 * This file is part of eds-sync
 *
 * Copyright (C) 2007 Nokia Corporation. All rights reserved.
 *
 * Author: Ross Burton <ross@openedhand.com>
 * Author: Onne Gorter <onne.gorter@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef _EDS_SYNC_TELEPATHY_H
#define _EDS_SYNC_TELEPATHY_H

#include <glib.h>
#include <libtelepathy/tp-conn.h>
#include <libtelepathy/tp-chan.h>
#include <libebook/e-book.h>
#include <libmissioncontrol/mission-control.h>
#include "gintset.h"
#include "eds-sync.h"
#include "notification.h"

G_BEGIN_DECLS

typedef struct {
  /* Global state pointer */
  EdsSync *sync;

  MissionControl *mc;

  TpConn *conn;

  TpChan *subscribe_chan; // channel with subscribed contacts
  TpChan *publish_chan; // channel with contacts to whom we publish our presence
  TpChan *known_chan; // optional, channel with all contacts known on server
  TpChan *blocked_chan; // optional, channel with all contacts blocked on server

  DBusGProxy *subscribe_chan_proxy; // interface to channel
  DBusGProxy *subscribe_group_proxy; // group interface for subscribe list
  DBusGProxy *publish_group_proxy; // group intefrace for publish list
  DBusGProxy *known_group_proxy; // group interface for known list
  DBusGProxy *blocked_group_proxy; // group interface for blocked list
  DBusGProxy *avatar_proxy; // proxy to the avatar interface
  DBusGProxy *aliasing_proxy; // proxy to the aliasing interface

  EBook *book;
  EBookView *view;

  guint self_handle; /* the self handle */
  char *account; /* the uid of the self handle */
  char *raw_account; /* the raw (unnormalized) uid of the self handle */
  char *vcard; /* the vcard field for this account */

  /* Indicates that EDS has finishing feeding contacts,
   * and a sync should be done
   */
  gboolean local_contacts_done;
  gboolean remote_subscribe_list_done;
  gboolean known_list_done;
  gboolean blocked_list_done;

  gboolean first_run;

  /* Indicates that something has actually changed since
   * the last time a sync was done. This avoids repeated
   * syncs for every contact added.
   */
  gboolean local_contacts_changed; // eds_changed

  /* A hash of (contact UID -> NULL) with tasks to do.  A hash so that we get
     duplicate handling for free. */
  GHashTable *local_contacts_todo;

  /* The set of handles that are on the server */
  GIntSet *remote_handles; // group_handles;

  /* The set of handles that are on the server, but wihtout any association */
  GIntSet *known_handles;

  /* The set of handles that are on the server, because they are blocked */
  GIntSet *blocked_handles;

  /* The set of handles that are locally blocked, because they are blocked */
  GIntSet *local_blocked_handles;

  /* The set of handles that are in EDS */
  GIntSet *local_handles; // eds_handles;

  /* The set of currently pending handles */
  GIntSet *pending_auth_handles;

  /* A hash table of handles to EContact UIDs */
  GHashTable *handle_to_contact_hash; // uid_hash

  /* notification interface */
  EdsNotifyContext *notify;

  /* List of EContacs which need to be committed */
  GList *to_commit;
} TelepathyContext;

gboolean eds_sync_telepathy_new (EdsSync *sync,
                                 TpConn *conn,
                                 const gchar *bus_name,
                                 const gchar *object_path,
                                 const gchar *channel_type,
                                 const gchar *channel,
                                 guint handle_type,
                                 guint handle,
                                 GError **error);

void   eds_sync_telepathy_add_uid    (TelepathyContext *context,
                                      const guint       handle,
                                      const gchar      *uid);
void   eds_sync_telepathy_remove_uid (TelepathyContext *context,
                                      const gchar      *uid);
GList* eds_sync_telepathy_lookup_uids (TelepathyContext *context,
                                       const guint       handle);

G_END_DECLS

#endif /* _EDS_SYNC_TELEPATHY_H */
