/*
 * This file is part of eds-sync
 *
 * Copyright (C) 2007 Nokia Corporation. All rights reserved.
 *
 * Author: Ross Burton <ross@openedhand.com>
 * Author: Onne Gorter <onne.gorter@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef __NOTIFICATION_H__
#define __NOTIFICATION_H__

#include <glib-object.h>

G_BEGIN_DECLS

#define EDS_TYPE_NOTIFY_CONTEXT           (eds_notify_context_get_type ())
#define EDS_NOTIFY_CONTEXT(obj)           (G_TYPE_CHECK_INSTANCE_CAST ((obj), EDS_TYPE_NOTIFY_CONTEXT, EdsNotifyContext))
#define EDS_IS_NOTIFY_CONTEXT(obj)        (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EDS_TYPE_NOTIFY_CONTEXT))
#define EDS_NOTIFY_CONTEXT_GET_IFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), EDS_TYPE_NOTIFY_CONTEXT, EdsNotifyContextIface))

typedef struct _EdsNotifyContext        EdsNotifyContext; /* dummy typedef */
typedef struct _EdsNotifyContextIface   EdsNotifyContextIface;

struct _EdsNotifyContextIface
{
  GTypeInterface g_iface;
  
  /* signals */
  void (* reply) (EdsNotifyContext *context,
                  gint              handle,
                  gboolean          response);

  /* vfuncs, not signals */
  gint (* auth_request)      (EdsNotifyContext *context,
                              gint              handle,
                              const gchar      *account,
                              const gchar      *name,
                              const gchar      *address,
                              const gchar      *message);
  gint (* auth_response)     (EdsNotifyContext *context,
                              gint              handle,
                              const gchar      *account,
                              const gchar      *address,
                              const gchar      *message,
                              gboolean          is_accepted);

  void (* cancel_operations) (EdsNotifyContext *context,
                              GArray           *ids);
};

GType eds_notify_context_get_type (void) G_GNUC_CONST;


gint eds_sync_notify_auth_request  (EdsNotifyContext *context,
                                    gint              handle,
                                    const gchar      *account,
                                    const gchar      *name,
                                    const gchar      *address,
                                    const gchar      *message);
gint eds_sync_notify_auth_response (EdsNotifyContext *context,
                                    gint              handle,
                                    const gchar      *account,
                                    const gchar      *address,
                                    const gchar      *message,
                                    gboolean          is_accepted);
void eds_sync_notify_cancel        (EdsNotifyContext *context,
                                    GArray           *ids);

EdsNotifyContext *eds_sync_get_notify_context (void);

G_END_DECLS

#endif /* __NOTIFICATION_H__ */
