/*
 * This file is part of eds-sync
 *
 * Copyright (C) 2007 Nokia Corporation. All rights reserved.
 *
 * Author: Ross Burton <ross@openedhand.com>
 * Author: Onne Gorter <onne.gorter@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#if HAVE_CONFIG_H
#include <config.h>
#endif

#include <glib.h>

#include <string.h>
#include <unistd.h>
#include <stdlib.h>

#include "eds-sync.h"

static const GDebugKey debug_keys[] = {
  { "events", DEBUG_EVENTS },
  { "handles", DEBUG_HANDLES },
  { "verbose", DEBUG_VERBOSE },
  { "avatars", DEBUG_AVATARS },
};

guint debug_flags = 0;

int
main (int argc, char **argv)
{
  GMainLoop *mainloop;
  EdsSync *sync;

  /* Initialize glib */
  g_type_init ();

  mainloop = g_main_loop_new (NULL, FALSE);

  g_debug("eds-sync %s starting", PACKAGE_VERSION);

  /* Initialize the debugging flags */
  debug_flags = g_parse_debug_string (g_getenv ("EDS_SYNC_DEBUG") ?: "",
                                      debug_keys, G_N_ELEMENTS (debug_keys));

  /* Create the EDS Sync object */
  sync = eds_sync_new ();

  /* If we now have a NULL object, then eds-sync is already running */
  if (sync == NULL) {
    g_main_loop_unref (mainloop);
    g_debug("exiting eds-sync, another eds-sync is already running");

    return EXIT_FAILURE;
  }

  /* Add a weak handler so the main loop quits when the object dies */
  g_object_weak_ref (G_OBJECT (sync), (GWeakNotify)g_main_loop_quit, mainloop);

  /* Go go go */
  g_main_loop_run (mainloop);

  /* Cleanup */
  g_main_loop_unref (mainloop);

  g_debug("exiting eds-sync");

  return EXIT_SUCCESS;
}
