/*
 * This file is part of eds-sync
 *
 * Copyright (C) 2007 Nokia Corporation. All rights reserved.
 *
 * Author: Ross Burton <ross@openedhand.com>
 * Author: Onne Gorter <onne.gorter@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef __EDS_SYNC_PRIV_H__
#define __EDS_SYNC_PRIV_H__

#include <glib.h>
#include <dbus/dbus-glib.h>

G_BEGIN_DECLS

struct _EdsSyncPrivate {
  DBusGConnection *connection;
  int chan_count;
  guint timeout_id;

  /* A hash of IM accounts to EContact UIDs for duplicate merging. */
  GHashTable *address_to_contact_hash;
};

gboolean tp_conn_inspect_handle (DBusGProxy *proxy,
                                 const guint IN_handle_type,
                                 const guint IN_handle,
                                 char ** OUT_arg2,
                                 GError **error);
gboolean tp_conn_request_handle (DBusGProxy *proxy,
                                 const guint IN_handle_type,
                                 const char * IN_name,
                                 guint *OUT_arg2,
                                 GError **error);

/* Functions to control the main account->contact map */
void                  eds_sync_register_account    (EdsSync     *sync,
                                                    const gchar *vcard_field,
                                                    const gchar *address,
                                                    const gchar *uid);
gboolean              eds_sync_has_account         (EdsSync     *sync,
                                                    const gchar *vcard_field,
                                                    const gchar *address);
G_CONST_RETURN gchar *eds_sync_get_uid_for_account (EdsSync     *sync,
                                                    const gchar *vcard_field,
                                                    const gchar *address);
void                  eds_sync_remove_uid          (EdsSync     *sync,
                                                    const gchar *uid);

G_END_DECLS

#endif /* __EDS_SYNC_PRIV_H__ */
