/*
 * This file is part of cx3110x
 *
 * Copyright (C) 2005, 2006 Nokia Corporation
 *
 * Contact: Kalle Valo <Kalle.Valo@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License 
 * version 2 as published by the Free Software Foundation. 
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 */

#include "sm_drv.h"
#include "sm_drv_ioctl.h"
#include "smoid2.h"


void send_formatted_event(struct net_device *dev, const char *str,
			  const struct obj_mlme *mlme, int error)
{
	return;
}
void send_simple_event(struct net_device *dev, const char *str)
{
	return;
}

void send_scan_complete_timer(unsigned long handle)
{
	return;
}


void send_scan_complete(struct net_device *dev)
{
	return;
}

void send_mic_failure(struct net_device *dev, struct obj_sta *sta)
{
	return;
}


struct iw_statistics * sm_drv_get_wireless_stats(struct net_device *dev)
{
	struct net_local *lp = dev->priv;

	spin_lock_bh(&lp->lock);
	memset(&lp->iwstatistics, 0, sizeof(struct iw_statistics));
	spin_unlock_bh(&lp->lock);

	return &lp->iwstatistics;	
}

int sm_drv_parse_bssid(struct net_device *dev, uint8_t * mac_filter, 
		       uint32_t event, char** event_stream)
{
	return 0;
}

int sm_drv_process_bss_data(struct net_device* dev,  u8 *addr, 
			     u8 *payload, size_t len, uint32_t event)
{
	return 0;
}

void sm_drv_wpa_ie_clean(struct net_device *dev)
{
	return;
}

/* MTUM are all private */

/*
 * Those are Manufacturing and Testing UpperMAC (MTUM)
 * related ioctls.
 * They will be available from the isl_3825mt.ko module.
 */

static int sm_drv_set_mtchannel(struct net_device *dev,
				struct iw_request_info *info,
				__u32 * uwrq, char *extra)
{
	uint32_t channel;
	uint32_t freq;

	if (uwrq == NULL)
		return -EINVAL;

	channel = *uwrq;

	DEBUG(DBG_IOCTL, "SET MTCHANNEL\n");
	if (channel < 0 || channel > 13)
		return -EINVAL;

	freq = freq_of_channel(channel); 

	return sm_drv_oid_set(dev, LMAC_MTUM_CHANNEL, (void *)&freq,
			      sizeof(uint32_t));
}

static int sm_drv_get_mtchannel(struct net_device *dev,
				struct iw_request_info *info,
				__u32 * uwrq, char *extra)
{
	uint32_t ret;
	uint32_t freq = 0;
	
	DEBUG(DBG_IOCTL, "GET MTCHANNEL\n");

	ret = sm_drv_oid_get(dev, LMAC_MTUM_CHANNEL, (void *)&freq,
			     sizeof(uint32_t));
	if (ret < 0)
		return ret;
	
	DEBUG(DBG_IOCTL, "Received frequency: %d\n", freq);

	*uwrq = channel_of_freq(freq/1000);
	return ret;
}


static int sm_drv_set_mtrate(struct net_device *dev,
			     struct iw_request_info *info,
			     __u32 * uwrq, char *extra)
{
	uint32_t rate;
	uint32_t ret;

	if (uwrq == NULL)
		return -EINVAL;

	rate = *uwrq;

	DEBUG(DBG_IOCTL, "SET MTRATE\n");
	
	ret = sm_drv_oid_set(dev, LMAC_MTUM_RATE, (void *)&rate,
			     sizeof(uint32_t));
	if (ret < 0)
		return ret;
	
	return ret;
}

static int sm_drv_get_mtrate(struct net_device *dev,
			     struct iw_request_info *info,
			     __u32 * uwrq, char *extra)
{
	uint32_t ret;
	uint32_t rate = 0;
	
	DEBUG(DBG_IOCTL, "GET MTRATE\n");
	
	ret = sm_drv_oid_get(dev, LMAC_MTUM_RATE, (void *)&rate,
			     sizeof(uint32_t));
	if (ret < 0)
		return ret;
	
	DEBUG(DBG_IOCTL, "Received rate: %d\n", rate);

	*uwrq = rate;
	return ret;
}

uint32_t power_loop_mode = 1;

static int sm_drv_set_mtdac(struct net_device *dev,
			    struct iw_request_info *info,
			    __u32 * uwrq, char *extra)
{
	uint32_t dac_value;
	uint32_t ret;
	uint32_t power_loop_mode = 0;

	if (uwrq == NULL)
		return -EINVAL;

	dac_value = *uwrq;

	DEBUG(DBG_IOCTL, "SET MTDAC\n");
	
	if (power_loop_mode) {
		power_loop_mode = 0;
		ret = sm_drv_oid_set(dev, LMAC_MTUM_POWERLOOP,
				     (void *)&power_loop_mode,
				     sizeof(uint32_t));
		if (ret < 0)
			return ret;
	}
	
	ret = sm_drv_oid_set(dev, LMAC_MTUM_POWER, (void *)&dac_value,
			     sizeof(uint32_t));
	if (ret < 0)
		return ret;

	return 0;
	
}

static int sm_drv_get_mtdac(struct net_device *dev,
			    struct iw_request_info *info,
			    __u32 * uwrq, char *extra)
{
	uint32_t power_value;
	uint32_t ret;
	
	DEBUG(DBG_IOCTL, "GET MTDAC\n");

	ret = sm_drv_oid_get(dev, LMAC_MTUM_POWER, (void *)&power_value,
			     sizeof(uint32_t));
	if (ret < 0)
		return ret;

	*uwrq = power_value;

	return 0;
}


static int sm_drv_mtreset(struct net_device *dev, struct iw_request_info *info,
			  __u32 * uwrq, char *extra)
{
	int ret, command = CMD_RESET, mode = TM_IDLE;
	
	/* Reseting must be done in idle mode */
	ret = sm_drv_oid_set(dev, LMAC_MTUM_MODE, &mode, sizeof(uint32_t));
	
	if (ret < 0)
		return 0;
	

	ret = sm_drv_oid_set(dev, LMAC_MTUM_CMD, (void *)&command,
			     sizeof(uint32_t));
	
	if (ret < 0)
		return 0;
	
	return 0;
}


#define MTUM_OID_MASK 0xff020000

static int sm_drv_set_mtum_oid_u32(struct net_device *dev,
				   struct iw_request_info *info,
				   __u32 * uwrq, char *extra)
{
	uint32_t oid, value;
	
	if (uwrq == NULL)
		return -EINVAL;

	oid = uwrq[0] | MTUM_OID_MASK;
	value = uwrq[1];
	
	DEBUG(DBG_IOCTL, "SET OID 32 with OID: 0x%x, value: %d\n", oid, value);
	return sm_drv_oid_set(dev, oid, (void *)&value, sizeof(uint32_t));
}

static int sm_drv_get_mtum_oid_u32(struct net_device *dev,
				   struct iw_request_info *info,
				   __u32 * uwrq, char *extra)
{
	uint32_t oid; 
	uint32_t value, ret = 0;
	
	if (uwrq == NULL || extra == NULL)
		return -EINVAL;

	oid = uwrq[0] | MTUM_OID_MASK;

	DEBUG(DBG_IOCTL, "GET OID 32 with OID: 0x%x\n", oid);
	
	ret = sm_drv_oid_get(dev, oid, (void *)&value, sizeof(uint32_t));
	if (ret < 0)
		return ret;
	
	DEBUG(DBG_IOCTL, "Got value: %d\n", value);
	
	memcpy(extra, &value, sizeof(value));
	return ret;
}

int sm_drv_get_wap(struct net_device *dev, struct iw_request_info *info,
		   struct sockaddr *awrq, char *extra)
{
	return 0;
}

int sm_drv_get_mode(struct net_device *dev, struct iw_request_info *info,
		    __u32 * uwrq, char *extra)
{
	return 0;
}


#define SM_DRV_SET_MTUM_OID_U32                  SIOCIWFIRSTPRIV + 2
#define SM_DRV_GET_MTUM_OID_U32                  SIOCIWFIRSTPRIV + 3

#define SM_DRV_SET_MTUM_CHANNEL                  SIOCIWFIRSTPRIV + 4
#define SM_DRV_GET_MTUM_CHANNEL                  SIOCIWFIRSTPRIV + 5

#define SM_DRV_SET_MTUM_RATE                     SIOCIWFIRSTPRIV + 6
#define SM_DRV_GET_MTUM_RATE                     SIOCIWFIRSTPRIV + 7

#define SM_DRV_SET_MTUM_DACVALUE                 SIOCIWFIRSTPRIV + 8
#define SM_DRV_GET_MTUM_DACVALUE                 SIOCIWFIRSTPRIV + 9

#define SM_DRV_MTUM_RESET                        SIOCIWFIRSTPRIV + 10


#define SM_DRV_MTUM_SET_U32(n,x) \
	{ n & 0xff, IW_PRIV_TYPE_INT | IW_PRIV_SIZE_FIXED | 1, 0, "set_mt"x }
#define SM_DRV_MTUM_GET_U32(n,x) \
	{ n & 0xff, 0, IW_PRIV_TYPE_INT | IW_PRIV_SIZE_FIXED | 1, "get_mt"x }


const iw_handler sm_drv_we_handler[] = {
	(iw_handler) sm_drv_commit,	/* SIOCSIWCOMMIT */
};

#define SM_DRV_SET_DEBUG                       SIOCIWFIRSTPRIV
const struct iw_priv_args sm_drv_we_private_args[] = {
	{SM_DRV_SET_DEBUG, IW_PRIV_TYPE_INT | IW_PRIV_SIZE_FIXED | 1,
	 0, "set_debug"},
	/*{ cmd, set_args, get_args, name } */
	{SM_DRV_SET_MTUM_CHANNEL, IW_PRIV_TYPE_INT | IW_PRIV_SIZE_FIXED | 1,
	 0, "set_mtchannel"},
	{SM_DRV_GET_MTUM_CHANNEL, 0, IW_PRIV_TYPE_INT | IW_PRIV_SIZE_FIXED | 1,
	 "get_mtchannel"},

	{SM_DRV_SET_MTUM_RATE, IW_PRIV_TYPE_INT | IW_PRIV_SIZE_FIXED | 1,
	 0, "set_mtrate"},
	{SM_DRV_GET_MTUM_RATE, 0, IW_PRIV_TYPE_INT | IW_PRIV_SIZE_FIXED | 1,
	 "get_mtrate"},

	{SM_DRV_SET_MTUM_DACVALUE, IW_PRIV_TYPE_INT | IW_PRIV_SIZE_FIXED | 1,
	 0, "set_mtdac"},
	{SM_DRV_GET_MTUM_DACVALUE, 0,
	 IW_PRIV_TYPE_INT | IW_PRIV_SIZE_FIXED | 1, "get_mtdac"},

	{SM_DRV_MTUM_RESET, 0, 0, "mtreset"},

	/* sub-ioctls handlers */
	{SM_DRV_SET_MTUM_OID_U32, IW_PRIV_TYPE_INT | IW_PRIV_SIZE_FIXED | 1,
	 0, ""},
	{SM_DRV_GET_MTUM_OID_U32, 0,
	 IW_PRIV_TYPE_INT | IW_PRIV_SIZE_FIXED | 1, ""},

	/* sub-ioctls definitions */
	SM_DRV_MTUM_SET_U32(LMAC_MTUM_MODE, "mode"),
	SM_DRV_MTUM_GET_U32(LMAC_MTUM_MODE, "mode"),

	SM_DRV_MTUM_SET_U32(LMAC_MTUM_TIMEOUT, "timeout"),
	SM_DRV_MTUM_GET_U32(LMAC_MTUM_TIMEOUT, "timeout"),
	
	SM_DRV_MTUM_SET_U32(LMAC_MTUM_CMD, "cmd"),

	SM_DRV_MTUM_SET_U32(LMAC_MTUM_PREAMBLE, "preamble"),
	SM_DRV_MTUM_GET_U32(LMAC_MTUM_PREAMBLE, "preamble"),

	SM_DRV_MTUM_SET_U32(LMAC_MTUM_INTERVAL, "interval"),
	SM_DRV_MTUM_GET_U32(LMAC_MTUM_INTERVAL, "interval"),

	SM_DRV_MTUM_SET_U32(LMAC_MTUM_LENGTH, "length"),
	SM_DRV_MTUM_GET_U32(LMAC_MTUM_LENGTH, "length"),

	SM_DRV_MTUM_SET_U32(LMAC_MTUM_PATTERN, "pattern"),
	SM_DRV_MTUM_GET_U32(LMAC_MTUM_PATTERN, "pattern"),

	SM_DRV_MTUM_SET_U32(LMAC_MTUM_MODULATION, "module"),
	SM_DRV_MTUM_GET_U32(LMAC_MTUM_MODULATION, "module"),

	SM_DRV_MTUM_SET_U32(LMAC_MTUM_SCRAMBLING, "scramble"),
	SM_DRV_MTUM_GET_U32(LMAC_MTUM_SCRAMBLING, "scramble"),
	
	SM_DRV_MTUM_SET_U32(LMAC_MTUM_FILTERTYPE, "filter"),
	SM_DRV_MTUM_GET_U32(LMAC_MTUM_FILTERTYPE, "filter"),

	SM_DRV_MTUM_SET_U32(LMAC_MTUM_ANTENNA_RX, "antrx"),
	SM_DRV_MTUM_GET_U32(LMAC_MTUM_ANTENNA_RX, "antrx"),

	SM_DRV_MTUM_SET_U32(LMAC_MTUM_ANTENNA_TX, "anttx"),
	SM_DRV_MTUM_GET_U32(LMAC_MTUM_ANTENNA_TX, "anttx"),

	SM_DRV_MTUM_SET_U32(LMAC_MTUM_POWERLOOP, "powloop"),
	SM_DRV_MTUM_GET_U32(LMAC_MTUM_POWERLOOP, "powloop"),

	SM_DRV_MTUM_GET_U32(LMAC_MTUM_RSSIVALUE, "rssi"),
	
	SM_DRV_MTUM_GET_U32(LMAC_MTUM_RCPI, "rcpi"),
	
	SM_DRV_MTUM_GET_U32(LMAC_MTUM_SQVALUE, "sq"),

	SM_DRV_MTUM_SET_U32(LMAC_MTUM_SYNTH, "synth"),
	SM_DRV_MTUM_GET_U32(LMAC_MTUM_SYNTH, "synth"),

	SM_DRV_MTUM_SET_U32(LMAC_MTUM_POWER, "power"),
	SM_DRV_MTUM_GET_U32(LMAC_MTUM_POWER, "power"),
	
	SM_DRV_MTUM_SET_U32(LMAC_MTUM_SYNTHNR, "synthnr"),
	SM_DRV_MTUM_GET_U32(LMAC_MTUM_SYNTHNR, "synthnr"),

	SM_DRV_MTUM_GET_U32(LMAC_MTUM_TXDONE, "txdone"),
	
	SM_DRV_MTUM_GET_U32(LMAC_MTUM_TXDUMPED, "txdumped"),

	SM_DRV_MTUM_GET_U32(LMAC_MTUM_RXSUCCESS, "rxsuccess"),
	
	SM_DRV_MTUM_GET_U32(LMAC_MTUM_RXFAILED, "rxfailed"),

	SM_DRV_MTUM_GET_U32(LMAC_MTUM_RXFAILED, "rxaborted"),

	SM_DRV_MTUM_GET_U32(LMAC_MTUM_RXFAILED, "rxabortphy"),
};

static const iw_handler sm_drv_we_private_handler[] = {
	(iw_handler) sm_drv_set_debug,
	(iw_handler) NULL,

	(iw_handler) sm_drv_set_mtum_oid_u32,
	(iw_handler) sm_drv_get_mtum_oid_u32,
	
	(iw_handler) sm_drv_set_mtchannel,
	(iw_handler) sm_drv_get_mtchannel,

	(iw_handler) sm_drv_set_mtrate,
	(iw_handler) sm_drv_get_mtrate,
	
	(iw_handler) sm_drv_set_mtdac,
	(iw_handler) sm_drv_get_mtdac,
	
	(iw_handler) sm_drv_mtreset,
	(iw_handler) NULL,
};

const struct iw_handler_def sm_drv_we_handler_def = {
	.num_standard = sizeof(sm_drv_we_handler) / sizeof(iw_handler),
	.num_private = sizeof(sm_drv_we_private_handler) / sizeof(iw_handler),
	.num_private_args =
	  sizeof(sm_drv_we_private_args) / sizeof(struct iw_priv_args),
	.standard = (iw_handler *) sm_drv_we_handler,
	.private = (iw_handler *) sm_drv_we_private_handler,
	.private_args = (struct iw_priv_args *) sm_drv_we_private_args,
};


