/*
 * This file is part of cx3110x
 *
 * Wireless extensions for Conexant CX3110x chipset.
 *
 * Copyright (C) 2005, 2006 Nokia Corporation
 *
 * Contact: Kalle Valo <Kalle.Valo@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License 
 * version 2 as published by the Free Software Foundation. 
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef _SM_DRV_IOCTL_H
#define _SM_DRV_IOCTL_H

#include <net/iw_handler.h>	/* New driver API */

#define SUPPORTED_WIRELESS_EXT                  16

extern const struct iw_handler_def sm_drv_we_handler_def;

int sm_drv_oid_get(struct net_device *dev, 
		   unsigned int oid_num, 
		   void * oid_object, 
		   unsigned int oid_size);
int sm_drv_oid_set(struct net_device *dev, 
		   unsigned int oid_num, 
		   void * oid_object, 
		   unsigned int oid_size);

int channel_of_freq(int f);
int freq_of_channel(int c);

int sm_drv_set_debug(struct net_device *dev, struct iw_request_info *info,
		     __u32 * uwrq, char *extra);

int sm_drv_commit(struct net_device *dev, struct iw_request_info *info,
		  char *cwrq, char *extra);

struct iw_statistics * sm_drv_get_wireless_stats(struct net_device *dev);
int sm_drv_parse_bssid(struct net_device *dev, 
		       uint8_t * mac_filter, 
		       uint32_t event,
		       char** event_stream);
int sm_drv_process_bss_data(struct net_device* dev,  u8 *addr, 
			     u8 *payload, size_t len, uint32_t event);
void sm_drv_wpa_ie_clean(struct net_device *dev);
void send_mic_failure(struct net_device *dev, struct obj_sta *sta);

void send_formatted_event(struct net_device *dev, const char *str,
			  const struct obj_mlme *mlme, int error);
void send_simple_event(struct net_device *dev, const char *str);
void send_scan_complete_timer(unsigned long handle);
void send_scan_complete(struct net_device *dev);

int sm_drv_get_wap(struct net_device *dev, struct iw_request_info *info,
		   struct sockaddr *awrq, char *extra);
int sm_drv_get_mode(struct net_device *dev, struct iw_request_info *info,
		    __u32 * uwrq, char *extra);



#endif
