/**
 * Clinkc-av control point test tool
 *
 * AV Transport Service tests
 *
 * Copyright (c) 2006 Nokia Corporation. All rights reserved.
 *
 * This is licensed under BSD-style license,
 * see file COPYING.
 */

#ifndef AV_AVTTEST_H
#define AV_AVTTEST_H

#include <cybergarage/upnp/ccontrolpoint.h>

#define NUM_AVT_TEST_CASES 11

#define TEST_CASE_AVT_SET_AVTRANSPORT_URI "AVT Set AVTransport URI Test"
#define TEST_CASE_AVT_GET_MEDIA_INFO "AVT Get Media Info Test"
#define TEST_CASE_AVT_GET_TRANSPORT_INFO "AVT Get Transport Info Test"
#define TEST_CASE_AVT_GET_POSITION_INFO "AVT Get Position Info Test"
#define TEST_CASE_AVT_GET_DEVICE_CAPABILITIES "AVT Get Device Capabilities Test"
#define TEST_CASE_AVT_GET_TRANSPORT_SETTINGS "AVT Get Transport Settings Test"
#define TEST_CASE_AVT_STOP "AVT Stop Test"
#define TEST_CASE_AVT_PLAY "AVT Play Test"
#define TEST_CASE_AVT_SEEK "AVT Seek Test"
#define TEST_CASE_AVT_NEXT "AVT Next Test"
#define TEST_CASE_AVT_PREVIOUS "AVT Previous Test"

int cp_test_avt_print_statistics();

int cp_test_avt(CgUpnpControlPoint* cp);

int cp_test_avt_set_avtransport_uri(CgUpnpControlPoint* cp, char* udn);
BOOL cp_test_avt_get_res_from_didllite(char* doc, char** uri);

int cp_test_avt_get_media_info(CgUpnpControlPoint* cp, char* udn);
int cp_test_avt_get_transport_info(CgUpnpControlPoint* cp, char* udn);
int cp_test_avt_get_position_info(CgUpnpControlPoint* cp, char* udn);
int cp_test_avt_get_device_capabilities(CgUpnpControlPoint* cp, char* udn);
int cp_test_avt_get_transport_settings(CgUpnpControlPoint* cp, char* udn);

int cp_test_avt_stop(CgUpnpControlPoint* cp, char* udn);
int cp_test_avt_play(CgUpnpControlPoint* cp, char* udn);

int cp_test_avt_seek(CgUpnpControlPoint* cp, char* udn);
int cp_test_avt_next(CgUpnpControlPoint* cp, char* udn);
int cp_test_avt_previous(CgUpnpControlPoint* cp, char* udn);

#endif
