/*
 * UPnP Browser for Maemo
 *
 * main.c
 *
 * Copyright 2005 Nokia Corporation. All rights reserved.
 *
 * This is licensed under BSD-style license,
 * see file COPYING.
 */

#include <hildon-widgets/hildon-app.h>
#include <hildon-widgets/hildon-appview.h>
#include <hildon-widgets/gtk-infoprint.h>
#include <gtk/gtkmain.h>
#include <gconf/gconf-client.h>
#include <libosso.h>

#include "../interface.h"
#include "../upnp.h"
#include "../settings.h"
#include "../now_playing.h"

extern UPnPBrowserWidgets* widgets;

int main( int argc, char* argv[] )
{
	widgets = g_new0(UPnPBrowserWidgets, 1);
	if (widgets == NULL)
	{
		return -1;
	}
	
	widgets->settings = g_new0(UPnPBrowserSettings, 1);
	if (widgets->settings == NULL)
	{
		return -1;
	}
	
	/* Initialize GTK. */
	gtk_init(&argc, &argv);

	/* Load settings */
	if (settings_load(widgets->settings) == FALSE)
	{
#ifdef MAEMO
		gtk_infoprint(NULL, "Unable to load settings");
#else
		fprintf(stderr, "Unable to load settings\n");
#endif
	}
	
	/* Create the hildon application and setup the title */
	widgets->app = hildon_app_new();
	hildon_app_set_title(HILDON_APP(widgets->app), "UPnP Browser");
	hildon_app_set_two_part_title(HILDON_APP(widgets->app), TRUE);
	
	/* Create HildonAppView and set it to HildonApp */
	widgets->appview = hildon_appview_new("");
	hildon_app_set_appview(HILDON_APP(widgets->app),
			       HILDON_APPVIEW(widgets->appview));
	
	widgets->toolbar = gtk_toolbar_new();
	hildon_appview_set_toolbar(HILDON_APPVIEW(widgets->appview),
				   GTK_TOOLBAR(widgets->toolbar));

	/* Create the interface widgets */
	create_widgets();
	
	widgets->osso = osso_initialize("upnpbrowser", VERSION, FALSE, NULL);
        if (!widgets->osso)
                g_warning("Could not initialize osso context from " PACKAGE);

	/* Begin the main application */
	gtk_widget_show_all(GTK_WIDGET(widgets->app));

	/* Initialize and start the control point */
	init_upnp_controlpoint();
	
	if (widgets->settings->updateServers == TRUE)
	{
		update_clicked();
	}

	update_now_playing_text();
	
	reset_now_playing_update_timeout(
		widgets->settings->transportUpdateInterval);

	gtk_main();

	destroy_upnp_controlpoint();

	osso_deinitialize(widgets->osso);

	if (settings_save(widgets->settings) == FALSE)
	{
#ifdef MAEMO
		gtk_infoprint(NULL, "Unable to save settings");
#else
		fprintf(stderr, "Unable to save settings\n");
#endif
	}

	g_free(widgets->settings);
	g_free(widgets);
	
	/* Exit */
	return 0;
}
