/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the EAL package.
 *
 * The Initial Developer of the Original Code is Nokia Corporation.
 * Portions created by the Initial Developer are Copyright (C) 2005
 * the Initial Developer. All Rights Reserved.
 *
 * Contact: Leonid Zolotarev <leonid.zolotarev@nokia.com>
 *
 * ***** END LICENSE BLOCK ***** */

#include "gwebtransferitem.h"

static void
g_web_transfer_item_base_init (gpointer g_class)
{
	static gboolean initialized = FALSE;

	if (!initialized) {
		/* create interface signals here. */
		initialized = TRUE;
	}
}

GType
g_web_transfer_item_get_type (void)
{
    static GType type = 0;
    if (type == 0) {
        static const GTypeInfo info = {
            sizeof (GWebTransferItemIface),
            g_web_transfer_item_base_init,   /* base_init */
            NULL,   /* base_finalize */
            NULL,   /* class_init */
            NULL,   /* class_finalize */
            NULL,   /* class_data */
            0,
            0,      /* n_preallocs */
            NULL    /* instance_init */
        };
        type = g_type_register_static (G_TYPE_INTERFACE, "GWebTransferItem", &info, 0);
    }
    return type;
}

void
g_web_transfer_item_destroy (GWebTransferItem *self)
{
	G_WEB_TRANSFER_ITEM_GET_CLASS (self)->destroy (self);
}

void
g_web_transfer_item_start (GWebTransferItem *self)
{
	G_WEB_TRANSFER_ITEM_GET_CLASS (self)->start (self);
}

void
g_web_transfer_item_stop (GWebTransferItem *self)
{
	G_WEB_TRANSFER_ITEM_GET_CLASS (self)->stop (self);
}

GWebStatus
g_web_transfer_item_continue (GWebTransferItem *self)
{
	return G_WEB_TRANSFER_ITEM_GET_CLASS (self)->do_continue (self);
}

void
g_web_transfer_item_cancel (GWebTransferItem *self)
{
	G_WEB_TRANSFER_ITEM_GET_CLASS (self)->cancel (self);
}

void
g_web_transfer_item_reload (GWebTransferItem *self)
{
	G_WEB_TRANSFER_ITEM_GET_CLASS (self)->reload (self);
}

GObject*
g_web_transfer_item_get_web_item (GWebTransferItem *self)
{
	return G_WEB_TRANSFER_ITEM_GET_CLASS (self)->get_web_item (self);
}

const gchar*
g_web_transfer_item_get_url (GWebTransferItem *self)
{
	return G_WEB_TRANSFER_ITEM_GET_CLASS (self)->get_url (self);
}

const gchar*
g_web_transfer_item_get_filename (GWebTransferItem *self)
{
	return G_WEB_TRANSFER_ITEM_GET_CLASS (self)->get_filename (self);
}

glong
g_web_transfer_item_get_total_size (GWebTransferItem *self)
{
	return G_WEB_TRANSFER_ITEM_GET_CLASS (self)->get_total_size (self);
}

glong
g_web_transfer_item_get_progress (GWebTransferItem *self)
{
	return G_WEB_TRANSFER_ITEM_GET_CLASS (self)->get_progress (self);
}
