/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the EAL package.
 *
 * The Initial Developer of the Original Code is Nokia Corporation.
 * Portions created by the Initial Developer are Copyright (C) 2005
 * the Initial Developer. All Rights Reserved.
 *
 * Contact: Leonid Zolotarev <leonid.zolotarev@nokia.com>
 *
 * ***** END LICENSE BLOCK ***** */

#include <glib-object.h>
#include "gwebcommon.h"

#ifndef __GWEBTRANSFERITEM_H__
#define __GWEBTRANSFERITEM_H__

G_BEGIN_DECLS

#define G_TYPE_WEB_TRANSFER_ITEM             (g_web_transfer_item_get_type ())
#define G_WEB_TRANSFER_ITEM(obj)             (G_TYPE_CHECK_INSTANCE_CAST ((obj), G_TYPE_WEB_TRANSFER_ITEM, GWebTransferItem))
#define G_WEB_TRANSFER_ITEM_CLASS(vtable)    (G_TYPE_CHECK_CLASS_CAST ((vtable), G_TYPE_WEB_TRANSFER_ITEM, GWebTransferItemIface))
#define G_IS_WEB_TRANSFER_ITEM(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), G_TYPE_WEB_TRANSFER_ITEM))
#define G_IS_WEB_TRANSFER_ITEM_CLASS(vtable) (G_TYPE_CHECK_CLASS_TYPE ((vtable), G_TYPE_WEB_TRANSFER_ITEM))
#define G_WEB_TRANSFER_ITEM_GET_CLASS(inst)  (G_TYPE_INSTANCE_GET_INTERFACE ((inst), G_TYPE_WEB_TRANSFER_ITEM, GWebTransferItemIface))

typedef struct _GWebTransferItem GWebTransferItem; /* dummy object */
typedef struct _GWebTransferItemIface GWebTransferItemIface;

/** @struct GWebTransferItemIface.
  * Defines transfer item interface.
  */
struct _GWebTransferItemIface {
	GTypeInterface parent;

	void (*destroy) (GWebTransferItem *self);
	void (*start) (GWebTransferItem *self);
	void (*stop) (GWebTransferItem *self);
	GWebStatus (*do_continue) (GWebTransferItem *self);
	void (*cancel) (GWebTransferItem *self);
	void (*reload) (GWebTransferItem *self);
	GObject* (*get_web_item) (GWebTransferItem *self);
	const gchar* (*get_url) (GWebTransferItem *self);
	const gchar* (*get_filename) (GWebTransferItem *self);
	glong (*get_total_size) (GWebTransferItem *self);
	glong (*get_progress) (GWebTransferItem *self);
};

GType g_web_transfer_item_get_type (void);

/** Destroy object.
  * @param self Object pointer
  */
void g_web_transfer_item_destroy (GWebTransferItem *self);

/** Start download.
  * @param self Object pointer
  */
void g_web_transfer_item_start (GWebTransferItem *self);

/** Stop download.
  * @param self Object pointer
  */
void g_web_transfer_item_stop (GWebTransferItem *self);

/** Continue download.
  * @param self Object pointer
  * @return @c G_WEB_STATUS_OK on success.
  */
GWebStatus g_web_transfer_item_continue (GWebTransferItem *self);

/** Cancel download.
  * @param self Object pointer
  */
void g_web_transfer_item_cancel (GWebTransferItem *self);

/** Reload item.
  * @param self Object pointer
  */
void g_web_transfer_item_reload (GWebTransferItem *self);

/** Get container object.
  * @param self Object pointer
  * @return Container object pointer
  */
GObject* g_web_transfer_item_get_web_item (GWebTransferItem *self);

/** Get item URL.
  * @param self Object pointer
  * @return URL string
  */
const gchar* g_web_transfer_item_get_url (GWebTransferItem *self);

/** Get item file name.
  * @param self Object pointer
  * @return File name string
  */
const gchar* g_web_transfer_item_get_filename (GWebTransferItem *self);

/** Get transfer item total size.
  * @param self Object pointer
  * @return Total size
  */
glong g_web_transfer_item_get_total_size (GWebTransferItem *self);

/** Get transfer item progress.
  * @param self Object pointer
  * @return Progress
  */
glong g_web_transfer_item_get_progress (GWebTransferItem *self);

/**
  * Transfer Item Signals.
  */

/**
  * "started" signal.
  */
#define G_WEB_TRANSFER_ITEM_SIGNAL_STARTED "started"

/** Signalled when the download has started
  * @param item Object pointer
  */
void g_web_transfer_item_signal_started(GWebTransferItem *item);

/**
  * "completed" signal.
  */
#define G_WEB_TRANSFER_ITEM_SIGNAL_COMPLETED "completed"

/** Signalled when the download is completed
  * @param item Object pointer
  */
void g_web_transfer_item_signal_completed(GWebTransferItem *item);

/**
  * "error" signal.
  */
#define G_WEB_TRANSFER_ITEM_SIGNAL_ERROR "error"

/** Signalled if an error occurs during transfer
  * @param item Object pointer
  */
void g_web_transfer_item_signal_error(GWebTransferItem *item);

/**
  * "progress" signal.
  */
#define G_WEB_TRANSFER_ITEM_SIGNAL_PROGRESS "progress"

/** Progress of the transfer 
  * @param item Object pointer
  * @param downloaded_bytes The number of bytes downloaded this far
  * @param total_bytes Total bytes downloaded this far
  * @param kbps Average kbps for this download
  */
void g_web_transfer_item_signal_progress(GWebTransferItem *item,
                                                                      gulong downloaded_bytes,
																	  gulong total_bytes,
																	  gdouble kbps);

G_END_DECLS

#endif /* __GWEBTRANSFERITEM_H__ */
