/*
 * Copyright © 2007 Siarhei Siamashka
 * Copyright © 2008 Nokia Corporation
 *
 * Permission to use, copy, modify, distribute and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the names of the authors and/or copyright holders
 * not be used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  The authors and
 * copyright holders make no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without any express
 * or implied warranty.
 *
 * THE AUTHORS AND COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO
 * THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS, IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR
 * ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 * CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Author: Siarhei Siamashka <siarhei.siamashka@nokia.com>
 */

/*
 * ARMv6 assembly optimized color format conversion functions (planar YV12 to
 * some custom YUV420 format used by graphics chip in Nokia N800/N810)
 */

#ifndef _OMAP_COLORCONV_H_
#define _OMAP_COLORCONV_H_

#include <stdint.h>

/**
 * Convert a line of pixels from YV12 to YUV420 color format
 * @param dst   - destination buffer for YUV420 pixel data, it should be at least 16-bit aligned
 * @param src_y - pointer to Y plane, it should be 16-bit aligned
 * @param src_c - pointer to chroma plane (U for even lines, V for odd lines)
 * @param w     - number of pixels to convert (should be multiple of 4)
 */
void yv12_to_yuv420_line_armv6(uint16_t *dst, const uint16_t *src_y, const uint8_t *src_c, int w);

#endif
