#! /bin/sh

# resulting ttf's go inside udeb-generated/
# stripped sfd's go inside udeb-build/
# customize using $FONTS, $STRIP_RANGES, $STRIP_CHAINSUB

FONTS="DejaVuSans DejaVuSansBold DejaVuSansOblique"
STRIP_RANGES=""
STRIP_RANGES=""
STRIP_RANGES="$STRIP_RANGES u0500:u052F" # Cyrillic Supplement
STRIP_RANGES="$STRIP_RANGES u0530:u058F" # Armenian
STRIP_RANGES="$STRIP_RANGES u0600:u06FF" # Arabic
STRIP_RANGES="$STRIP_RANGES u0700:u074F" # Syriac
STRIP_RANGES="$STRIP_RANGES u0E80:u0EFF" # Lao
STRIP_RANGES="$STRIP_RANGES u1400:u167F" # Canadian Syllabics
STRIP_RANGES="$STRIP_RANGES u1D00:u1DBF" # Phonetic Extensions
STRIP_RANGES="$STRIP_RANGES u1F00:u1FFF" # Greek Extended
STRIP_RANGES="$STRIP_RANGES u2070:u209f" # Superscripts and Subscripts
STRIP_RANGES="$STRIP_RANGES u20a0:u20cf" # Currency Symbols
STRIP_RANGES="$STRIP_RANGES u2150:u218f" # Number Forms
STRIP_RANGES="$STRIP_RANGES u2190:u21ff" # Arrows
STRIP_RANGES="$STRIP_RANGES u2200:u24FF" # Mathematical, Techical, Control, OCR
STRIP_RANGES="$STRIP_RANGES u2580:u25FF" # Block elements, Geometric Shapes
STRIP_RANGES="$STRIP_RANGES u2600:u26FF" # Miscellaneous Symbols
STRIP_RANGES="$STRIP_RANGES u2700:u27EF" # Dingbats, Miscellaneous Mathematical Symbols-A
STRIP_RANGES="$STRIP_RANGES u27F0:u27FF" # Supplemental Arrows-A
STRIP_RANGES="$STRIP_RANGES u2800:u28FF" # Braille Patterns
STRIP_RANGES="$STRIP_RANGES u2900:u2BFF" # Suppl. Arrows-B, Misc Math Symbols-B, Supplath Ops, Misc Symbols and Arrows
STRIP_RANGES="$STRIP_RANGES u2C60:u2C7F" # Latin Extended-C
STRIP_RANGES="$STRIP_RANGES u3000:u30FF" # CJK Symbols and Punctuation
STRIP_RANGES="$STRIP_RANGES uFB50:uFBFF" # Arabic Presentation Forms-A
STRIP_RANGES="$STRIP_RANGES uFE70:uFEFF" # Arabic Presentation Forms-B

# ---------------------------------------------------------------------------
set -e

udir="udeb-build"
result="udeb-generated"

rm -rf "$udir" "$result"
mkdir "$udir"
mkdir "$udir/generated"

for f in $FONTS; do
  echo "`basename $0`: stripping $f.sfd"
  fontforge -script debian/scripts/strip_glyphs.pe "$f.sfd" "$udir/$f.sfd" $STRIP_RANGES
done

(cd "$udir" && ../generate.pe *.sfd)
./ttpostproc.pl "$udir"/generated/*.ttf
mv "$udir/generated" "$result"

# vim:set tw=0 nowrap ts=8 sw=2 sts=2:
