/* -*- Mode: C; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/*
 * This file is part of telepathy-feed
 *
 * Copyright (C) 2006 Nokia Corporation. All rights reserved.
 *
 * Contact: Onne Gorter <onne.gorter@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef _SHARED_H
#define _SHARED_H

#include <libtelepathy/tp-conn.h>

extern DBusGConnection *gconnection;
extern DBusConnection *connection;

typedef struct {
  TpConn *conn;
  TpChan *chan;

  GHashTable *account_hash;
  GHashTable *statuses;
  GArray *galago_caps;
  
  DBusGProxy *presence_proxy;
  DBusGProxy *group_proxy;
  DBusGProxy *caps_proxy;

  guint status;

  char *account_username;
  
  guint self_handle;
  guint list_handle;
} FeedContext;

/* Debugging flags */
enum {
  DEBUG_ALL = 1 << 0,
  DEBUG_PRESENCE = 1 << 1,
  DEBUG_CAPS = 1 << 2,
  DEBUG_DBUS = 1 << 3,
  DEBUG_AVATARS = 1 << 4,
};

extern guint debug_flags;

#define tp_debug(flag, format...)       G_STMT_START {  \
        if (debug_flags & (flag)) {                     \
                g_debug (G_STRLOC ": " format);         \
        }                               } G_STMT_END

#define v_debug(format...)        tp_debug (DEBUG_ALL, format)
#define p_debug(format...)        tp_debug (DEBUG_PRESENCE | DEBUG_ALL, format)
#define c_debug(format...)        tp_debug (DEBUG_CAPS | DEBUG_ALL, format)
#define d_debug(format...)        tp_debug (DEBUG_DBUS | DEBUG_ALL, format)
#define a_debug(format...)        tp_debug (DEBUG_AVATARS | DEBUG_ALL, format)

#endif /* _SHARED_H */
