/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Tablet Browser Interface package.
 *
 * The Initial Developer of the Original Code is Nokia Corporation.
 * Portions created by the Initial Developer are Copyright (C) 2005
 * the Initial Developer. All Rights Reserved.
 *
 * Contact: Leonid Zolotarev <leonid.zolotarev@nokia.com>
 *
 * ***** END LICENSE BLOCK ***** */

#ifndef __OSSO_BROWSER_INTERFACE_H__
#define __OSSO_BROWSER_INTERFACE_H__

/*!
  DBUS service provided by the browser
*/
#define OSSO_BROWSER_SERVICE           "com.nokia.osso_browser"

/*!
  DBUS Interface for requesting the service. 
*/
#define OSSO_BROWSER_REQ_INTERFACE    "com.nokia.osso_browser.request"

/**
 * DBUS object path for requesting the service. 
 */ 
#define OSSO_BROWSER_REQ_PATH         "/com/nokia/osso_browser/request"

/* URL loading service */

/**
 * Open new browser window in normal/full screen mode. \n
 * \b url: The URL to load in new browser window\n
 * \b argument2: TRUE if Open new browser window in full screen mode, FALSE otherwise.\n
 * \b Example: Open new window with home page in normal/full screen mode.
 * \code
 * ret = osso_rpc_run_with_defaults(app_ctx, "osso_browser",
 *                         OSSO_BROWSER_OPEN_NEW_WINDOW_REQ, NULL, 
 *                         DBUS_TYPE_STRING, "new_window", DBUS_TYPE_BOOLEAN, FALSE,
 *                         DBUS_TYPE_INVALID);
 * \endcode
 * \b Example: Open new window with url in normal/full screen mode.
 * \code
 * ret = osso_rpc_run_with_defaults(app_ctx, "osso_browser",
 *                         OSSO_BROWSER_OPEN_NEW_WINDOW_REQ, NULL, 
 *                         DBUS_TYPE_STRING, url, DBUS_TYPE_BOOLEAN, FALSE, DBUS_TYPE_INVALID);
 * \endcode
 *
 */ 
#define OSSO_BROWSER_OPEN_NEW_WINDOW_REQ    "open_new_window"

/**
 * Load URL in current browser window.\n
 * \b url: The URL to load\n
 * \b argument2: TRUE if Load URL in full screen mode, FALSE otherwise.\n
 * \b Example: Load Home page in currently open browser window 
 * \code
 * ret = osso_rpc_run_with_defaults(app_ctx, "osso_browser",
 *                         OSSO_BROWSER_LOAD_URL_REQ, NULL, 
 *                         DBUS_TYPE_STRING, "new_window",  DBUS_TYPE_BOOLEAN, FALSE, DBUS_TYPE_INVALID);
 * \endcode
 * \b Example: Load URL in the currently open browser window. 
 * \code
 * ret = osso_rpc_run_with_defaults(app_ctx, "osso_browser",
 *                         OSSO_BROWSER_LOAD_URL_REQ, NULL, 
 *                         DBUS_TYPE_STRING, url, DBUS_TYPE_BOOLEAN, FALSE, DBUS_TYPE_INVALID);
 * \endcode
 *
 */ 
#define OSSO_BROWSER_LOAD_URL_REQ    "load_url"

/**
 * Send this to close top_window.
 */ 
#define OSSO_BROWSER_CLOSE    "close_window"

/**
 * Send this to close browser.
 */ 
#define OSSO_BROWSER_EXIT    "exit_browser"

/**
 * Send this to save url.
 */
#define OSSO_BROWSER_SAVE_URL_REQ    "save_url"

#endif /* __OSSO_BROWSER_INTERFACE_H__ */
