/*
  osso-wlan-dev OSSO WLAN connectivity header files
  Copyright (C) 2005 Nokia Corporation

  This library is free software; you can redistribute it and/or modify it
  under the terms of the GNU Lesser General Public License version 2.1 as 
  published by the Free Software Foundation.

  This library is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
  General Public License for more details.

  You should have received a copy of the GNU Lesser General Public License
  along with this library; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

/**
  @file eap-dbus.h

  Copyright (C) 2004 Nokia. All rights reserved.

  @author Janne Ylalehto <janne.ylalehto@nokia.com>
*/

#ifndef _EAP_DBUS_H_
#define _EAP_DBUS_H_

/* EAP DBUS defines */
#define EAP_SERVICE                      "com.nokia.eap"
#define EAP_REQ_INTERFACE                "com.nokia.eap.request"
#define EAP_SIG_INTERFACE                "com.nokia.eap.signal"

#define EAP_SIG_PATH                     "/com/nokia/eap/signal"
#define EAP_REQ_PATH                     "/com/nokia/eap/request"

#define EAP_ERROR_INIT_FAILED            "com.nokia.eap.error.init"
#define EAP_ERROR_OUT_OF_MEMORY          "com.nokia.eap.error.out_of_memory"
#define EAP_ERROR_ALREADY_ACTIVE         "com.nokia.eap.error.already_active"
#define EAP_ERROR_FATAL                  "com.nokia.eap.error.fatal"
#define EAP_ERROR_INVALID_PARAMS         "org.freedesktop.DBus.Error.InvalidArgs"

#define EAP_INTERFACE_REQ                "interface"
#define EAP_DISCONNECT_REQ               "disconnect"
#define EAP_STATUS_REQ                   "status"
#define EAP_WPA_IE_PUSH_REQ              "wpa_ie_push"
#define EAP_WPA_MIC_FAILURE_REQ          "wpa_mic_failure"
#define EAP_DISASSOCIATE_REQ             "disassociate"
#define EAP_NAI_UPDATE_REQ               "nai_update_req"

#define EAP_AUTH_STATUS_SIG              "auth_status"
#define EAP_DISCONNECTED_SIG             "disconnected"

/* Auth status */

#define EAP_STATUS_MASK      (0xff)
#define EAP_STARTING         (1 << 0)
#define EAP_IN_PROGRESS      (1 << 1)
#define EAP_SUCCESS          (1 << 2)
#define EAP_FAILED           (1 << 3)

#define EAP_REASON_CODE_MASK (0xffffff00)
#define ILLEGAL_CERTIFICATE  (1 << 8)
#define INVALID_BDA          (1 << 9)
#define GENERAL_BT_ERROR     (1 << 10)
#define SAP_NOT_SUPPORTED    (1 << 11)
#define BT_DISABLED          (1 << 12)
#define CONFIGURATION_ERROR  (1 << 13)
#define MIC_FAILURE          (1 << 14)

/* DBUS Parameter limitations */

#define EAP_PSK_MIN_LEN 8
#define EAP_PSK_MAX_LEN 63

#define EAP_SSID_MIN_LEN 1
#define EAP_SSID_MAX_LEN 32

#define EAP_IAP_MAX_LEN 128

/* Interface request definitions */

#define EAP_REMOVE_INTERFACE 1
#define EAP_ADD_INTERFACE    2

#define EAP_WLAN_INTERFACE   1
#define EAP_WIMAX_INTERFACE  2

#endif // _EAP_DBUS_H_
