/**
    @file debug.h

    Debug macros.
    
    Copyright (c) 2004, 2005 Nokia Corporation.

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License 
    version 2 or later, as published by the Free Software Foundation. 

    This program is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
    02110-1301 USA	
*/

#ifndef DEBUG_H
#define DEBUG_H
#include <stdio.h>
#include <time.h>

#define DEBUG_NONE //no debug message
//#define DEBUG_GLIB //use glib subsystem for the debug messages
//#define DEBUG_FILE //save the debug messages into a file

#ifdef DEBUG_NONE

#define DMSG(args...) 

#endif

#ifdef DEBUG_GLIB

#define DMSG(args...) g_message(args...)

#endif

#ifdef DEBUG_FILE

#define DMSG(args...) do { \
	printf(args); \
	FILE *bla; \
  	bla=fopen("/tmp/testrsslib.txt","a+"); \
	fprintf (bla, "%d: ",(int)time(NULL)); \
  	fprintf (bla, args); \
	fflush(bla); \
	fclose(bla); \
	} while (0)

#endif

#endif
