/*
 * This file is part of DSP Gateway version 3.3.1
 *
 * Copyright (C) 2003-2006 Nokia Corporation. All rights reserved.
 *
 * Contact: Toshihiro Kobayashi <toshihiro.kobayashi@nokia.com>
 *          Kiyotaka Takahashi <kiyotaka.takahashi@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License 
 * version 2 as published by the Free Software Foundation. 
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef __DLD_SYMBOL_H
#define __DLD_SYMBOL_H

#include "list.h"
#include "dsp_dld.h"

extern int symbol_createlist(struct list_head *list, u16 n);
extern void symbol_freelist(struct list_head *list, struct coffobj *cobj);
extern int symbol_filllist(struct coff *coff, u8 *src,
			   struct coffobj *cobj, u16 n);
#ifdef STICKY_LIST
extern int symbol_register_global(struct list_head *list);
#endif
extern struct symbol *symbol_find_by_name(struct list_head *list, char *name);
extern struct symbol *symbol_find_scnsym(struct list_head *list,
					 struct section *scn);
extern void symbol_sendstat(struct list_head *list, int fd);
#ifdef ENABLE_HASH
extern int symbol_resolve_with_hash(struct coffobj *kcobj, struct coffobj *cobj);
#else
extern int symbol_resolve(struct list_head *list_knl, struct list_head *list);
#endif

/*
 * debug stuff
 */
extern void symbol_printstat(struct list_head *list);

#endif /* __DLD_SYMBOL_H */
