/*
 * @file nitro-handler.h
 *
 * This file contains the function headers
 * for  nitro-handler.c.
 *
 * This file is part of nitro
 *
 * Copyright (C) 2007-2008 Nokia Corporation. 
 *
 * Contact: Eero Tamminen <eero.tamminen@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License 
 * version 2 as published by the Free Software Foundation. 
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef NITRO_HANDLER_H
#define NITRO_HANDLER_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <libintl.h>

#define _(String) dgettext(PACKAGE,String)

#define NITRO_GCONF_CONNECTION_STATUS_DIR	"/apps/osso/nitro/connection"
#define NITRO_GCONF_CONNECTION_STATUS		NITRO_GCONF_CONNECTION_STATUS_DIR"/Connection"
#define NITRO_GCONF_DELETE_STATUS		"/apps/osso/nitro/deleteAfterSending"

/* ERROR CODES */
#define NITRO_SUCCESS 0

#define NITRO_BASE 9000
#define NITRO_NO_SETTINGS_ERROR		(NITRO_BASE+1)
#define NITRO_CURL_COULD_NOT_CONN_ERROR	(NITRO_BASE+2)
#define NITRO_CURL_FILE_NOT_FOUND	(NITRO_BASE+2)

typedef enum {
	CONN_NOT_INITIATED,
	CONN_INITIATED,
	CONN_CONNECTED,
	CONN_DISCONNECTED
} NITROConnectionState;

/**
  This function is to initiate a connection to the default IAP.
  Uploading of the raw data file will be done in the connection
  callback function after successful connection to IAP is made.

  @param void
  @return TRUE on success else FALSE.
  */
gboolean nitro_connect_iap(void);

/**
  This function will initialize the nitro_libs

  @param void
  @return if success TRUE  else FALSE
  */
gboolean nitro_libs_init(void);


/**
  This function will store the NITROConnectionState value as gconf data

  @param NITROConnectionState value
  @return TRUE if success else FALSE
  */
gboolean nitro_libs_gconf_set_connc_status(NITROConnectionState val);

/**
  This function will get the NITROConnectionState value from gconf file

  @param NITROConnectionState value
  @return TRUE if success else FALSE
  */
gboolean nitro_libs_gconf_get_connc_status(NITROConnectionState *val);


/**
  This function uploads the files to the configured server

  @param the text_uri of the file to upload
  @return NITRO_ERROR in case of failure else NITRO_SUCCESS
*/
gboolean nitro_upload(gchar * file);
#endif
