/**
 * @file nitro-daemon-monitor.h
 * 
 * This file contains the directory monitoring function prototypes.
 * In case Rich cores are generated the NITRO UI Application is launched. 
 * 
 * This file is part of nitro
 *
 * Copyright (C) 2007-2008 Nokia Corporation. 
 *
 * Contact: Eero Tamminen <eero.tamminen@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License 
 * version 2 as published by the Free Software Foundation. 
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef NITRO_DAEMON_MONITOR_FILE_H
#define NITRO_DAEMON_MONITOR_FILE_H

#include <libgnomevfs/gnome-vfs.h>
#include <libgnomevfs/gnome-vfs-utils.h>
#include <libgnomevfs/gnome-vfs-file-info.h>
#include <libgnomevfs/gnome-vfs-ops.h>
#include <gconf/gconf-client.h>
#include <libosso.h>
#include <glib/gstdio.h>
#include <log-functions.h>
#include <osso-log.h>
#include <string.h>

osso_context_t *context;

/**
  This function sets the monitors for MMC1 and MMC2
  The monitor_event() will be called when any changes
  are done to the monitored directories

  @param gchar* path monitor (which must be MMC1_CORES_LOCATION or MMC2_CORES_LOCATION)
  @return TRUE if success else FALSE
  */
gboolean set_directory_monitor(gchar * location);
/** 
  This function checks for the presence of core files in 
  'core-dumps' directories in both the MMCs. If present, it will 
  send the cores by calling send_all_rich_cores()

  @param void
  @param void
*/
void check_for_cores(void); 
#endif
