/*
 * @file nitro-settings-dialog.h
 *
 * This file contains the implementation of
 * settings dialog.
 *
 * This file is part of nitro
 *
 * Copyright (C) 2007-2008 Nokia Corporation. 
 *
 * Contact: Eero Tamminen <eero.tamminen@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License 
 * version 2 as published by the Free Software Foundation. 
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef NITRO_SETTINGS_DIALOG_H_
#define NITRO_SETTINGS_DIALOG_H_

#include <glib.h>
#include <gtk/gtk.h>
#include <libintl.h>
#include <libosso.h>

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#define _(String) dgettext(PACKAGE,String)

#define SCRIPT				"/etc/init.d/nitro_init"
#define NITRO_DAEMON			"nitro_daemon"
#define NITRO_CP_HELP_ID		"applications_nitro_settings"
#define MMC_PRESENT    			"/system/osso/af/mmc-device-present"
#define INTERNAL_MMC_PRESENT    	"/system/osso/af/internal-mmc-device-present"
#define EXT_MMC				"/media/mmc1/core-dumps"
#define INT_MMC				"/media/mmc2/core-dumps"
#define RICH_CORE_CONFIG		"/etc/rich-core.conf"

#define PRIVACY_STATEMENT_FILE		"/usr/share/nitro-settings/privacy.txt"

typedef struct _nitroData  nitroData;

/**
 *   This structure has the elements for
 *   settings dialog
 **/
struct _nitroData {
	GtkWidget* checkbox_nitro;
	GtkWidget* checkbox_include_core;
	GtkWidget* checkbox_include_syslog;
	GtkWidget* checkbox_include_pkglist;

	GtkWidget *caption_privacy;
	GtkWidget *caption_include_core;
	GtkWidget *caption_include_syslog;
	GtkWidget *caption_include_pkglist;
};

typedef enum {
	CP_RESPONSE_OK,
	CP_RESPONSE_CANCEL,
	CP_RESPONSE_DISCLAIMER
} CpDialogResponse;

typedef enum {
	CP_CONF_REMOVE,
	CP_CONF_IGNORE
} CpConfResponse;

/**
  This function is called for creation of settings dialog.
  
  @param data is the pointer to the nitroData struct
  @param context is the pointer to the osso context
  
  @return none 
  */
void 
nitro_cp_dialog_create(gpointer data,osso_context_t *context);

#endif
