/*
 * @file nitro-cp-applet.c
 *
 * This file contains the implementation of
 * control panel applet for NITRO.
 * 
 * This file is part of nitro
 *
 * Copyright (C) 2007-2008 Nokia Corporation. 
 *
 * Contact: Eero Tamminen <eero.tamminen@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License 
 * version 2 as published by the Free Software Foundation. 
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#include <glib.h>
#include <gtk/gtk.h>
#include <osso-log.h>
#include <log-functions.h>
#include <libosso.h>
#include <libgnomevfs/gnome-vfs-init.h>

#include "nitro-settings-dialog.h"

/**
  Definition of execute interface for NITRO applet, used by any calling
  application (primary user: Control Panel application).
 
  @param osso	osso context of the calling application.
  @param data  Pointer to gtk window of the calling application.
  @param user_activated   Flag indicating calling mode, either normal user
 			   activation or system activation.
 */
osso_return_t 
execute(osso_context_t *osso, gpointer data,
	        gboolean user_activated);

osso_return_t 
execute(osso_context_t *osso, gpointer data,
	        gboolean user_activated)
{
	gnome_vfs_init();
	g_type_init();
	nitro_cp_dialog_create(data, osso);

	return OSSO_OK;
}
