/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the MICROB EAL package.
 *
 * The Initial Developer of the Original Code is Nokia Corporation.
 * Portions created by the Initial Developer are Copyright (C) 2005
 * the Initial Developer. All Rights Reserved.
 *
 * Contact: Oleg Romashin <oleg.romashin@nokia.com>
 *
 * ***** END LICENSE BLOCK ***** */

#include <gwebtransferitemlist.h>

#ifndef __GMOZILLATRANSFERITEMLIST_H__
#define __GMOZILLATRANSFERITEMLIST_H__

G_BEGIN_DECLS

/* GMozillaTransferItemList */

#define G_TYPE_MOZILLA_TRANSFER_ITEM_LIST             (g_mozilla_transfer_item_list_get_type ())
#define G_MOZILLA_TRANSFER_ITEM_LIST(obj)             (G_TYPE_CHECK_INSTANCE_CAST ((obj), G_TYPE_MOZILLA_TRANSFER_ITEM_LIST, GMozillaTransferItemList))
#define G_MOZILLA_TRANSFER_ITEM_LIST_CLASS(vtable)    (G_TYPE_CHECK_CLASS_CAST ((vtable), G_TYPE_MOZILLA_TRANSFER_ITEM_LIST, GMozillaTransferItemListClass))
#define G_IS_MOZILLA_TRANSFER_ITEM_LIST(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), G_TYPE_MOZILLA_TRANSFER_ITEM_LIST))
#define G_IS_MOZILLA_TRANSFER_ITEM_LIST_CLASS(vtable) (G_TYPE_CHECK_CLASS_TYPE ((vtable), G_TYPE_MOZILLA_TRANSFER_ITEM_LIST))
#define G_MOZILLA_TRANSFER_ITEM_LIST_GET_CLASS(inst)  (G_TYPE_INSTANCE_GET_INTERFACE ((inst), G_TYPE_MOZILLA_TRANSFER_ITEM_LIST, GMozillaTransferItemListClass))

typedef struct _GMozillaTransferItemList GMozillaTransferItemList;
typedef struct _GMozillaTransferItemListClass GMozillaTransferItemListClass;

/** @struct GMozillaTransferItemList.
  * Defines a Mozilla Transfer Item List.
  */
struct _GMozillaTransferItemList
{
    GObject parent;    /** < Object parent */

    GObject **items;   /** < Object items */
    gint num_items;    /** < Number of item in the list */
};

struct _GMozillaTransferItemListClass
{
    GObjectClass parent;
};

GType g_mozilla_transfer_item_list_get_type (void);

/** Creates a new tranfer item list's instance
  * @return A transfer item list.
  */
GObject* g_mozilla_transfer_item_list_new (void);

G_END_DECLS

#endif /* __GMOZILLATRANSFERITEMLIST_H__ */
