/*
 * This file is part of maemopad
 *
 * Copyright (C) 2005-2008 Nokia Corporation. All rights reserved.
 *
 * This maemo code example is licensed under a MIT-style license,
 * that can be found in the file called "COPYING" in the root
 * directory.
 *
 */

#ifndef CALLBACKS_H
#define CALLBACKS_H

#include <ui/interface.h>
#include <gtk/gtk.h>
#include <appdata.h>
#include <hildon/hildon-help.h>

#define HELP_TOPIC_ID "Example_MaemoPad_Content"

/* file-> new/open/save */
void callback_file_new ( GtkAction * action, gpointer data );
void callback_file_open ( GtkAction * action, gpointer data );
void callback_file_save ( GtkAction * action, gpointer data );
void callback_file_saveas ( GtkAction * action, gpointer data );

/* edit-> cut/copy/paste */
void callback_edit_cut ( GtkAction * action, gpointer data );
void callback_edit_copy ( GtkAction * action, gpointer data );
void callback_edit_paste ( GtkAction * action, gpointer data );
/* sendvia->email/bluetooth*/
void callback_sendvia_email ( GtkAction * action, gpointer data );
void callback_sendvia_bt ( GtkAction * action, gpointer data );

/* font */
void callback_font ( GtkAction * action, gpointer data );
/* fullscreen */
void callback_fullscreen ( GtkAction * action, gpointer data );
/* help */
void callback_help ( GtkAction * action, gpointer data );

/* buffer modified */
void callback_buffer_modified ( GtkAction * action, gpointer data );


/* Key presses event */
gboolean key_press(GtkWidget * widget, GdkEventKey * event,
                     gpointer data);
gboolean key_release(GtkWidget * widget, GdkEventKey * event,
                     gpointer data);



#endif
