/**
    UPnP/AV GnomeVFS seek/tell tester

    This application is used for testing UPnP/AV plugin from command line.
    
    Copyright 2008 Nokia Corporation. All rights reserved.
	
    Contact: Aapo Makela <aapo.makela@nokia.com>
    
    This library is free software; you can redistribute it and/or modify it
    under the terms of the GNU Lesser General Public License version 2.1 as 
    published by the Free Software Foundation.
  
    This library is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
    General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with this library; if not, write to the Free Software Foundation,
    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

#include <stdlib.h>
#include <time.h>
#include <strings.h>
#include <string.h>

#include <glib.h>
#include <libgnomevfs/gnome-vfs.h>

#include <dbus/dbus.h>
#include <dbus/dbus-glib-lowlevel.h>

static gboolean perform_test(gpointer data)
{
    gchar large_buf[1024];
    gchar *url = (gchar *)data;
    gchar buf[1]; GnomeVFSResult res, res2;
    GnomeVFSFileSize curpos, cnt;
    GnomeVFSHandle *handle = NULL;
    gboolean eos = FALSE;

    /* Open file */
    g_debug("Opening the file...");
    res = gnome_vfs_open(&handle, url, GNOME_VFS_OPEN_READ);
    if (res != GNOME_VFS_OK)
    {
        g_warning("Error in opening file: %s",
                  gnome_vfs_result_to_string(res));
        goto end;
    }

    /* First read big chunk */
    g_debug("Reading the file...");
    res = gnome_vfs_read(handle, large_buf, 1024, &cnt);
    if (res != GNOME_VFS_OK)
    {
        g_warning("Error in reading file: %s",
                  gnome_vfs_result_to_string(res));
        goto end;
    }

    /* Then tell + small read + seek */
    g_debug("Getting current position...");
    gnome_vfs_tell(handle, &curpos);

    g_debug("Reading one character...");
    res2 = gnome_vfs_read(handle, buf, 1, &cnt);
    if (res2 == GNOME_VFS_ERROR_EOF)
        eos = TRUE;
    else eos = FALSE;

    g_debug("Seeking back...");
    gnome_vfs_seek (handle, GNOME_VFS_SEEK_START, curpos);

end:
    /* Close handle */
    g_debug("Closing file.");
    if (handle) gnome_vfs_close(handle);
    return FALSE;
}

int main (int argc, char **argv)
{
    GMainLoop *mainloop = NULL;
    DBusConnection *sys_conn = NULL;

    if (argc != 2)
    {
        g_print("Usage: %s <URL>\n", argv[0]);
        return 1;
    }

    gnome_vfs_init ();

    mainloop = g_main_loop_new(NULL, FALSE);
    if (mainloop == NULL)  
    {
        g_error("Unable to initialize main loop.");
        return 1;
    }
  
    sys_conn = dbus_bus_get(DBUS_BUS_SYSTEM, NULL);
    if (sys_conn == NULL)
    {
        g_error("Unable to initialize connection to DBUS");
        g_main_loop_unref(mainloop);
        return 1;
    }

    /* setup D-Bus to use the Glib main loop */
    dbus_connection_setup_with_g_main(sys_conn, NULL);

    g_idle_add(perform_test, argv[1]);

    /* Go to mainloop */
    g_main_loop_run(mainloop);
    g_main_loop_unref(mainloop);

    gnome_vfs_shutdown();
    return 0;
}
