/*
 * linux/include/asm-arm/arch-omap/sec.h
 *
 * Copyright (C) 2007 Nokia Corporation
 * Author: Sami Tolvanen <sami.tolvanen@nokia.com>
 *
 * OMAP HS secure mode driver
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 */

#define SEC_HACK_SYMBIAN_WRAPPER

#define SEC_HAL_NOTEXEC		0x00000000
#define SEC_HAL_OK		0x00000001
#define SEC_HAL_FAIL		0x00000002
#define SEC_HAL_ENOMEM		0x00000007
#define SEC_HAL_ENOPA		0xFFFFFFFF

typedef struct {
	struct device *dev; /* sysfs device */
} sec_hal_init;

typedef struct {
	u16 length;
	u8 index;
	u8 reserved;
} sec_hal_par_common;

typedef struct {
	u32 rv; /* Secure mode return value */
} sec_hal_res_common;

typedef struct {
	u32 (*rpc_ptr)(u32, u32, u32, u32);
	void *storage_ptr;
	u32 length;
} sec_hal_par_secenv_init;

typedef struct {
	void *data;
	u32 length;
} sec_hal_par_random_get;

typedef struct {
	int (*hal_init)(sec_hal_init *);
	void (*hal_exit)(void);
	u32 (*rpc_alloc)(u32);
	void (*rpc_dealloc)(u32);
	u32 (*secenv_init)(sec_hal_par_secenv_init *);
	u32 (*random_get)(sec_hal_par_random_get *);
	u32 (*pa_query)(u32, u8 *, u32, u32 *, u32 *);
	u32 (*pa_service)(u32, u8 *, u32, u8 *, u32);
} sec_hal_operations;

extern int sec_hal_register(sec_hal_operations *ops);
extern int sec_hal_deregister(sec_hal_operations *ops);
